/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.FieldAccessorImpl;

abstract class UnsafeFieldAccessorImpl
extends FieldAccessorImpl {
    static final Unsafe unsafe = Unsafe.getUnsafe();
    protected final Field field;
    protected final long fieldOffset;
    protected final boolean isFinal;

    UnsafeFieldAccessorImpl(Field field) {
        this.field = field;
        this.fieldOffset = Modifier.isStatic(field.getModifiers()) ? unsafe.staticFieldOffset(field) : unsafe.objectFieldOffset(field);
        this.isFinal = Modifier.isFinal(field.getModifiers());
    }

    protected void ensureObj(Object object) {
        if (!this.field.getDeclaringClass().isAssignableFrom(object.getClass())) {
            this.throwSetIllegalArgumentException(object);
        }
    }

    private String getQualifiedFieldName() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    protected IllegalArgumentException newGetIllegalArgumentException(String string) {
        return new IllegalArgumentException("Attempt to get " + this.field.getType().getName() + " field \"" + this.getQualifiedFieldName() + "\" with illegal data type conversion to " + string);
    }

    protected void throwFinalFieldIllegalAccessException(String string, String string2) throws IllegalAccessException {
        throw new IllegalAccessException(this.getSetMessage(string, string2));
    }

    protected void throwFinalFieldIllegalAccessException(Object object) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException(object != null ? object.getClass().getName() : "", "");
    }

    protected void throwFinalFieldIllegalAccessException(boolean bl) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("boolean", Boolean.toString(bl));
    }

    protected void throwFinalFieldIllegalAccessException(char c) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("char", Character.toString(c));
    }

    protected void throwFinalFieldIllegalAccessException(byte by) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("byte", Byte.toString(by));
    }

    protected void throwFinalFieldIllegalAccessException(short s) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("short", Short.toString(s));
    }

    protected void throwFinalFieldIllegalAccessException(int n) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("int", Integer.toString(n));
    }

    protected void throwFinalFieldIllegalAccessException(long l) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("long", Long.toString(l));
    }

    protected void throwFinalFieldIllegalAccessException(float f) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("float", Float.toString(f));
    }

    protected void throwFinalFieldIllegalAccessException(double d) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("double", Double.toString(d));
    }

    protected IllegalArgumentException newGetBooleanIllegalArgumentException() {
        return this.newGetIllegalArgumentException("boolean");
    }

    protected IllegalArgumentException newGetByteIllegalArgumentException() {
        return this.newGetIllegalArgumentException("byte");
    }

    protected IllegalArgumentException newGetCharIllegalArgumentException() {
        return this.newGetIllegalArgumentException("char");
    }

    protected IllegalArgumentException newGetShortIllegalArgumentException() {
        return this.newGetIllegalArgumentException("short");
    }

    protected IllegalArgumentException newGetIntIllegalArgumentException() {
        return this.newGetIllegalArgumentException("int");
    }

    protected IllegalArgumentException newGetLongIllegalArgumentException() {
        return this.newGetIllegalArgumentException("long");
    }

    protected IllegalArgumentException newGetFloatIllegalArgumentException() {
        return this.newGetIllegalArgumentException("float");
    }

    protected IllegalArgumentException newGetDoubleIllegalArgumentException() {
        return this.newGetIllegalArgumentException("double");
    }

    protected String getSetMessage(String string, String string2) {
        String string3 = "Can not set";
        if (Modifier.isStatic(this.field.getModifiers())) {
            string3 = string3 + " static";
        }
        if (this.isFinal) {
            string3 = string3 + " final";
        }
        string3 = string3 + " " + this.field.getType().getName() + " field " + this.getQualifiedFieldName() + " to ";
        string3 = !string2.isEmpty() ? string3 + "(" + string + ")" + string2 : (!string2.isEmpty() ? string3 + string : string3 + "null value");
        return string3;
    }

    protected void throwSetIllegalArgumentException(String string, String string2) {
        throw new IllegalArgumentException(this.getSetMessage(string, string2));
    }

    protected void throwSetIllegalArgumentException(Object object) {
        this.throwSetIllegalArgumentException(object != null ? object.getClass().getName() : "", "");
    }

    protected void throwSetIllegalArgumentException(boolean bl) {
        this.throwSetIllegalArgumentException("boolean", Boolean.toString(bl));
    }

    protected void throwSetIllegalArgumentException(byte by) {
        this.throwSetIllegalArgumentException("byte", Byte.toString(by));
    }

    protected void throwSetIllegalArgumentException(char c) {
        this.throwSetIllegalArgumentException("char", Character.toString(c));
    }

    protected void throwSetIllegalArgumentException(short s) {
        this.throwSetIllegalArgumentException("short", Short.toString(s));
    }

    protected void throwSetIllegalArgumentException(int n) {
        this.throwSetIllegalArgumentException("int", Integer.toString(n));
    }

    protected void throwSetIllegalArgumentException(long l) {
        this.throwSetIllegalArgumentException("long", Long.toString(l));
    }

    protected void throwSetIllegalArgumentException(float f) {
        this.throwSetIllegalArgumentException("float", Float.toString(f));
    }

    protected void throwSetIllegalArgumentException(double d) {
        this.throwSetIllegalArgumentException("double", Double.toString(d));
    }
}

