/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilFxHelper;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.stub.XfilCrawlStub;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class XfilCrawlPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField nameField = new FxTextField();
    FxButton completionButton = FxUtil.createCompletionButton();
    FxButton cancelButton = FxUtil.createCancelButton();
    XfilCrawl crawl1;
    Stage stage;

    public XfilCrawlPane() throws Exception {
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        this.nameField.setPrefColumnCount(80);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().CrawlName.toPlain()), new Node[]{this.nameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setData(XfilCrawl crawl) throws Exception {
        this.crawl1 = crawl;
        this.nameField.setText(crawl.name);
    }

    protected void storeData(XfilCrawl crawl) throws Exception {
        crawl.name = this.nameField.getText();
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData(this.crawl1);
            XfilCrawlStub.getInstance().putCrawl(this.crawl1);
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
        XfilFxHelper.getInstance().remove(((Object)((Object)this)).getClass(), this.crawl1.id);
    }

    public void show(long crawlId) throws Exception {
        XfilCrawl crawl = XfilCrawlStub.getInstance().getCrawl(crawlId);
        this.setData(crawl);
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(320.0);
        this.stage.setResizable(false);
        this.stage.setTitle(XfilWords.getInstance().Crawl.toPlain());
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }
}

