/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.common;

import ext.base.log.BcLogUtil;
import ext.lib.poi.PoiWorkbookUtil;
import ext.module.impt.common.ImptAbstractRecordParser;
import ext.module.impt.model.ImptImportDefine;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ImptWorkbookParser
extends ImptAbstractRecordParser {
    protected ImptImportDefine importDefine;
    int clolumnMax;
    int rowMax;

    @Override
    public void doParse(ImptImportDefine importDefine, InputStream is) throws Exception {
        this.importDefine = importDefine;
        Workbook ssWorkbook = PoiWorkbookUtil.createWorkbook(is);
        this.clolumnMax = PoiWorkbookUtil.getColumnSizeMax(ssWorkbook);
        this.rowMax = PoiWorkbookUtil.getRowSizeMax(ssWorkbook);
        int i = 0;
        while (i < ssWorkbook.getNumberOfSheets()) {
            Sheet ssSheet = ssWorkbook.getSheetAt(i);
            BcLogUtil.info("(" + (i + 1) + "/" + ssWorkbook.getNumberOfSheets() + ") sheetName=" + ssWorkbook.getSheetName(i));
            this.parseSheet(ssWorkbook, ssSheet, i + 1);
            ++i;
        }
    }

    @Override
    public void doParse(ImptImportDefine importDefine, File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        this.doParse(importDefine, fis);
    }

    public void parseSheet(Workbook workbook, Sheet sheet, int sheetNo) throws Exception {
        int i = 0;
        while (i <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i);
            if (row != null) {
                this.parseRow(workbook, sheet, sheetNo, row, i + 1);
            }
            ++i;
        }
    }

    protected void parseRow(Workbook workbook, Sheet sheet, int sheetNo, Row row, int rowNo) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < row.getLastCellNum()) {
            Cell cell = row.getCell(i);
            String strValue = null;
            if (cell != null) {
                strValue = this.parseCell(workbook, sheet, sheetNo, row, rowNo, cell, i + 1);
            }
            valueList.add(strValue);
            ++i;
        }
        this.newRow(sheetNo, rowNo, valueList);
    }

    protected String parseCell(Workbook workbook, Sheet sheet, int sheetNo, Row row, int rowNo, Cell cell, int colNo) throws Exception {
        String strValue = null;
        if (cell != null) {
            strValue = PoiWorkbookUtil.getCellValueAsString(cell);
        }
        return strValue;
    }
}

