/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcInteger;
import ext.base.util.BcCollectionUtil;
import ext.lib.swg.SwgComponentUnit;
import ext.lib.swg.SwgControl;
import ext.lib.swg.SwgUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class SwgFormLayout
implements LayoutManager,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3881996245448773642L;
    public static final int VERTICAL = 1;
    public static final int FLOW = 2;
    public int topMargin = 2;
    protected int topMarginWk;
    public int bottomMargin = 2;
    public int leftMargin = 2;
    protected int leftMarginWk;
    public int leftRightSpace = 2;
    public int rightNodeSpace = 2;
    public int rowSpace = 2;
    public int unitSpace = 20;
    public int layoutType = 1;
    protected Container parent;
    public List<SwgComponentUnit> componentUnitList = new ArrayList<SwgComponentUnit>();
    protected Map<Integer, UnitContext> unitContextMap;

    public SwgFormLayout(int layoutType) throws Exception {
        this.layoutType = layoutType;
    }

    public SwgFormLayout() throws Exception {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.parent = parent;
        Dimension dim = new Dimension(0, 0);
        try {
            this.layoutContainer_L2(dim);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.parent = parent;
        Dimension dim = new Dimension(0, 0);
        try {
            this.layoutContainer_L2(dim);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.parent = parent;
        try {
            this.layoutContainer_L2(null);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutContainer_L2(Dimension dim1) throws Exception {
        this.topMarginWk = this.topMargin;
        this.leftMarginWk = this.leftMargin;
        Object object = this.parent.getTreeLock();
        synchronized (object) {
            int parentHeight;
            JComponent jComponent;
            Border border;
            this.createUnitContextMap();
            if (JComponent.class.isAssignableFrom(this.parent.getClass()) && (border = (jComponent = (JComponent)this.parent).getBorder()) != null) {
                this.topMarginWk += border.getBorderInsets((Component)jComponent).top;
                this.leftMarginWk += border.getBorderInsets((Component)jComponent).left;
            }
            if (this.componentUnitList.size() > 0) {
                switch (this.layoutType) {
                    case 1: {
                        this.verticalLayout_L1();
                        break;
                    }
                    default: {
                        this.frowlLayout_L1();
                    }
                }
                return;
            }
            Component[] components = this.parent.getComponents();
            if (components.length <= 0) {
                return;
            }
            int parentWidth = this.parent.getWidth();
            if (parentWidth <= 0 && this.parent.getParent() != null) {
                parentWidth = this.parent.getParent().getWidth();
            }
            if ((parentHeight = this.parent.getHeight()) <= 0) {
                this.parent.getParent();
            }
            int lx = this.leftMarginWk;
            int ly = this.topMarginWk;
            int columnCnt = -1;
            int heightMaxInRow = 0;
            int i = 0;
            while (i < components.length) {
                Component component = components[i];
                if (!component.isEnabled()) {
                    if (dim1 == null) {
                        component.setLocation(0, 0);
                        component.setSize(0, 0);
                    }
                } else {
                    Container container;
                    LayoutManager layoutManager;
                    int componentHeight;
                    boolean nextRow = false;
                    ++columnCnt;
                    int componentWidth = component.getPreferredSize().width;
                    if (componentWidth <= 0) {
                        componentWidth = parentWidth - component.getX() - this.leftMarginWk;
                    }
                    if ((componentHeight = component.getPreferredSize().height) <= 0 && Container.class.isAssignableFrom(component.getClass()) && (layoutManager = (container = (Container)component).getLayout()) != null && SwgFormLayout.class.isAssignableFrom(layoutManager.getClass())) {
                        SwgFormLayout formLayout = (SwgFormLayout)layoutManager;
                        componentHeight = formLayout.minimumLayoutSize((Container)container).height;
                    }
                    if (SwgControl.class.isAssignableFrom(component.getClass())) {
                        SwgControl control = (SwgControl)((Object)component);
                        nextRow = control.getNextRowForce();
                    }
                    if (!nextRow && lx + componentWidth + this.leftRightSpace > parentWidth) {
                        nextRow = true;
                    }
                    if (nextRow) {
                        lx = this.leftMarginWk;
                        ly += heightMaxInRow;
                        ly += this.rowSpace;
                        parentHeight += heightMaxInRow;
                        heightMaxInRow = 0;
                        columnCnt = 1;
                        if (SwgControl.class.isAssignableFrom(component.getClass())) {
                            SwgControl swgControl = (SwgControl)((Object)component);
                        }
                    }
                    if (dim1 == null) {
                        component.setLocation(lx, ly);
                        component.setSize(componentWidth, componentHeight);
                    }
                    lx += componentWidth + this.leftRightSpace;
                    if (componentHeight > heightMaxInRow) {
                        heightMaxInRow = componentHeight;
                    }
                }
                ++i;
            }
            parentHeight = ly + heightMaxInRow;
            if (dim1 != null) {
                dim1.width += parentWidth;
                dim1.height += parentHeight;
            } else {
                this.parent.setSize(new Dimension(parentWidth, parentHeight));
            }
        }
    }

    protected void createUnitContextMap() throws Exception {
        this.unitContextMap = new HashMap<Integer, UnitContext>();
        int i = 0;
        while (i < this.componentUnitList.size()) {
            SwgComponentUnit componentUnit = this.componentUnitList.get(i);
            if (componentUnit.isEnabled()) {
                List<Component> rightComponentList;
                UnitContext unitContext = new UnitContext();
                this.unitContextMap.put(componentUnit.hashCode(), unitContext);
                Component leftComponent = componentUnit.getLeftComponent();
                if (leftComponent != null) {
                    unitContext.height = leftComponent.getPreferredSize().height;
                }
                if ((rightComponentList = componentUnit.rightComponentList) != null) {
                    int j = 0;
                    while (j < rightComponentList.size()) {
                        Component rightComponent = rightComponentList.get(j);
                        if (rightComponent != null) {
                            unitContext.height = Math.max(unitContext.height, rightComponent.getPreferredSize().height);
                            if (j > 0) {
                                unitContext.rightWidth += this.rightNodeSpace;
                            }
                            unitContext.rightWidth += rightComponent.getPreferredSize().width;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    protected void verticalLayout_L1() throws Exception {
        SwgComponentUnit componentUnit;
        int ay = this.topMarginWk;
        int ax = this.leftMarginWk;
        int leftMax = 0;
        int rightMax = 0;
        ArrayList<UnitContext> unitContextList = new ArrayList<UnitContext>();
        int i = 0;
        while (i < this.componentUnitList.size()) {
            componentUnit = this.componentUnitList.get(i);
            if (componentUnit.isEnabled()) {
                UnitContext unitContext1 = this.unitContextMap.get(componentUnit.hashCode());
                if (i > 0) {
                    ay += this.rowSpace;
                }
                if (ay + this.rowSpace + unitContext1.height + this.bottomMargin > this.parent.getHeight()) {
                    int j = 0;
                    while (j < unitContextList.size()) {
                        UnitContext unitContext2 = (UnitContext)unitContextList.get(j);
                        unitContext2.leftWidth = leftMax;
                        ++j;
                    }
                    unitContextList.clear();
                    ay = this.topMarginWk;
                    ax = ax + leftMax + this.leftRightSpace + rightMax + this.unitSpace;
                    leftMax = 0;
                    rightMax = 0;
                }
                unitContextList.add(unitContext1);
                unitContext1.x = ax;
                unitContext1.y = ay;
                Component leftComponent = componentUnit.getLeftComponent();
                if (leftComponent != null) {
                    leftMax = Math.max(leftMax, leftComponent.getPreferredSize().width);
                    rightMax = Math.max(rightMax, unitContext1.rightWidth);
                    ay += unitContext1.height;
                }
            }
            ++i;
        }
        int j = 0;
        while (j < unitContextList.size()) {
            UnitContext unitContext2 = (UnitContext)unitContextList.get(j);
            unitContext2.leftWidth = leftMax;
            ++j;
        }
        i = 0;
        while (i < this.componentUnitList.size()) {
            componentUnit = this.componentUnitList.get(i);
            if (componentUnit.isEnabled()) {
                UnitContext unitContext = this.unitContextMap.get(componentUnit.hashCode());
                this.verticalLayout_L2(componentUnit, unitContext);
            }
            ++i;
        }
    }

    protected void verticalLayout_L2(SwgComponentUnit componentUnit, UnitContext unitContext) throws Exception {
        Component leftComponent = componentUnit.getLeftComponent();
        if (leftComponent != null) {
            int x1 = unitContext.x + unitContext.leftWidth - leftComponent.getPreferredSize().width;
            int y1 = unitContext.y + (unitContext.height - leftComponent.getPreferredSize().height) / 2;
            SwgUtil.setLocation(this.parent, leftComponent, (double)x1, (double)y1);
        }
        int x2 = unitContext.x + unitContext.leftWidth + this.leftRightSpace;
        List<Component> rightComponentList = componentUnit.rightComponentList;
        if (rightComponentList == null) {
            return;
        }
        int i = 0;
        while (i < rightComponentList.size()) {
            Component rightComponent = rightComponentList.get(i);
            if (rightComponent != null) {
                if (i > 0) {
                    x2 += this.rightNodeSpace;
                }
                SwgUtil.setLocation(this.parent, rightComponent, (double)x2, (double)unitContext.y);
                x2 += rightComponent.getPreferredSize().width;
            }
            ++i;
        }
    }

    protected void frowlLayout_L1() throws Exception {
        BcInteger x = new BcInteger();
        x.value += this.leftMarginWk;
        BcInteger y = new BcInteger();
        y.value += this.topMarginWk;
        int i = 0;
        while (i < this.componentUnitList.size()) {
            SwgComponentUnit componentUnit = this.componentUnitList.get(i);
            this.frowlLayout_L2(componentUnit, x, y);
            x.value += this.unitSpace;
            ++i;
        }
    }

    protected void frowlLayout_L2(SwgComponentUnit componentUnit, BcInteger x, BcInteger y) throws Exception {
        Component leftComponent = componentUnit.getLeftComponent();
        SwgUtil.setLocation(this.parent, leftComponent, (double)x.value, (double)y.value);
        x.value += leftComponent.getPreferredSize().width;
        x.value += this.leftRightSpace;
        List<Component> rightComponentList = componentUnit.rightComponentList;
        int i = 0;
        while (i < rightComponentList.size()) {
            Component rightComponent = rightComponentList.get(i);
            SwgUtil.setLocation(this.parent, rightComponent, (double)x.value, (double)y.value);
            x.value += rightComponent.getPreferredSize().width;
            x.value += this.leftRightSpace;
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            SwgFormLayout obj = (SwgFormLayout)super.clone();
            obj.componentUnitList = new ArrayList<SwgComponentUnit>();
            BcCollectionUtil.copy(this.componentUnitList, obj.componentUnitList, true);
            obj.unitContextMap = new HashMap<Integer, UnitContext>();
            BcCollectionUtil.copy(this.unitContextMap, obj.unitContextMap, true);
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[leftMarginWk=" + this.leftMarginWk + "topMarginWk=" + this.topMarginWk + "labelSpace=" + this.leftRightSpace + ",rowSpace=" + this.rowSpace + "]";
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    class UnitContext
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -6909607199755031376L;
        public int x;
        public int y;
        public int leftWidth;
        public int rightWidth;
        public int height;

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

