/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.utils;

import java.util.function.Function;
import oracle.jdbc.driver.utils.CheckedExceptionHandler;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Throwable>
extends Function<T, R> {
    public R applyOrThrow(T var1) throws E;

    @Override
    default public R apply(T input) {
        try {
            return this.applyOrThrow(input);
        }
        catch (Throwable throwable) {
            throw CheckedExceptionHandler.toRuntimeException(throwable);
        }
    }
}

