/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.fx;

import ext.base.util.BcCloneUtil;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.module.xmmd.fx.XmmdEventHandler;
import ext.module.xmmd.fx.XmmdFieldListPane;
import ext.module.xmmd.fx.XmmdFieldPane;
import ext.module.xmmd.fx.XmmdHeaderPane;
import ext.module.xmmd.model.XmmdField;
import ext.module.xmmd.model.XmmdModel;
import ext.module.xmmd.stub.XmmdModelStub;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XmmdModelEditor
implements XmmdEventHandler {
    protected FxDecoratePane decoratePane = new InnerDecoratePane();
    protected SplitPane splitPane = new SplitPane();
    protected XmmdHeaderPane mmdHeaderPane = new XmmdHeaderPane();
    protected XmmdFieldListPane fieldListPane = new XmmdFieldListPane();
    protected XmmdFieldPane mmdFieldPane = new XmmdFieldPane();
    protected XmmdModel xmmdModel1;
    protected XmmdModel xmmdModel2;
    protected Stage stage;

    public XmmdModelEditor() throws Exception {
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.mmdHeaderPane.setPrefSize(10.0, 100.0);
        this.decoratePane.setTop((Node)this.mmdHeaderPane);
        this.splitPane.getItems().addAll((Object[])new Node[]{this.fieldListPane, this.mmdFieldPane});
        this.splitPane.setDividerPositions(new double[]{0.3f, 0.6f});
        this.decoratePane.setCenter((Node)this.splitPane);
        this.fieldListPane.addEventHandler(this);
        this.setFont(FxFontUtil.font_12b);
    }

    public void setFont(Font font) throws Exception {
        FxUtil.setFont((Node)this.decoratePane, font);
        FxUtil.setPrefSize((Node)this.decoratePane);
    }

    protected void storeData() throws Exception {
        this.mmdHeaderPane.storeData();
    }

    public void setData(XmmdModel xmmdModel1) throws Exception {
        this.xmmdModel1 = xmmdModel1;
        this.xmmdModel2 = BcCloneUtil.createClone(xmmdModel1);
        this.mmdHeaderPane.setXmmd(this.xmmdModel2);
        this.fieldListPane.setData(this.xmmdModel2, null);
        if (this.xmmdModel2.getFieldCount() <= 0) {
            XmmdField xmmdField = this.createDefault(1);
            this.xmmdModel2.addField(xmmdField);
            this.mmdSelected_L2(xmmdField);
        } else {
            XmmdField xmmdField = this.xmmdModel2.getField(0);
            this.mmdSelected_L2(xmmdField);
        }
    }

    public XmmdField createDefault(int seq) throws Exception {
        XmmdField mmdField = new XmmdField();
        mmdField.columnName = "field_" + seq;
        mmdField.sqlTypeId = 12;
        mmdField.dataSize = 20;
        return mmdField;
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new Stage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.APPLICATION_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                XmmdModelEditor.this.splitPane.setDividerPositions(new double[]{0.4f, 0.6f});
            }
        });
        FxScene scene = new FxScene((Parent)this.decoratePane);
        this.stage.setScene((Scene)scene);
        this.stage.centerOnScreen();
        this.stage.setResizable(true);
        this.stage.setWidth(1400.0);
        this.stage.setHeight(800.0);
        this.stage.setTitle("Data Madel Editor");
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }

    @Override
    public void mmdSelected(Object obj) throws Exception {
        if (obj instanceof XmmdField) {
            XmmdField mmdField = (XmmdField)obj;
            if (this.mmdFieldPane.xmmdField != null) {
                this.mmdFieldPane.storeData();
                BcResult result = new BcResult();
                if (result.hasError()) {
                    String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                    FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
                    return;
                }
            }
            this.mmdSelected_L2(mmdField);
        }
    }

    public void mmdSelected_L2(XmmdField xmmdField) throws Exception {
        this.mmdFieldPane.setXmmdField(xmmdField);
    }

    class InnerDecoratePane
    extends FxDecoratePane {
        Button completionButton;
        Button cancelButton;
        Button button3;

        public InnerDecoratePane() throws Exception {
            this.completionButton = this.createButton(BcWords.getInstance().completion);
            this.cancelButton = this.createButton(BcWords.getInstance().cancel);
            this.button3 = this.createButton("\u884c\u8ffd\u52a0");
        }

        @Override
        public void actionPerformed(ActionEvent ev) throws Exception {
            super.actionPerformed(ev);
            if (ev.getSource() == this.completionButton) {
                XmmdModelEditor.this.storeData();
                BcResult result = new BcResult();
                if (result.hasError()) {
                    String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                    FxOptionPane.showMessageDialog((Window)XmmdModelEditor.this.stage, (Object)message, BcWords.getInstance().warning, 2);
                    return;
                }
                XmmdModelStub.getInstance().putDataModel(XmmdModelEditor.this.xmmdModel2);
                XmmdModelEditor.this.stage.close();
            } else if (ev.getSource() == this.cancelButton) {
                XmmdModelEditor.this.stage.close();
            } else if (ev.getSource() == this.button3) {
                XmmdField mmdField = XmmdModelEditor.this.createDefault(XmmdModelEditor.this.xmmdModel2.getFieldCount() + 1);
                XmmdModelEditor.this.xmmdModel2.addField(mmdField);
                XmmdModelEditor.this.mmdSelected_L2(mmdField);
                XmmdModelEditor.this.fieldListPane.setData(XmmdModelEditor.this.xmmdModel2, null);
            }
        }
    }
}

