/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import sun.awt.CausedFocusEvent;

public class JToggleButton
extends AbstractButton
implements Accessible {
    private static final String uiClassID = "ToggleButtonUI";

    public JToggleButton() {
        this(null, null, false);
    }

    public JToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JToggleButton(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JToggleButton(String string) {
        this(string, null, false);
    }

    public JToggleButton(String string, boolean bl) {
        this(string, null, bl);
    }

    public JToggleButton(Action action) {
        this();
        this.setAction(action);
    }

    public JToggleButton(String string, Icon icon) {
        this(string, icon, false);
    }

    public JToggleButton(String string, Icon icon, boolean bl) {
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(bl);
        this.init(string, icon);
    }

    @Override
    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    boolean shouldUpdateSelectedStateFromAction() {
        return true;
    }

    JToggleButton getGroupSelection(CausedFocusEvent.Cause cause) {
        switch (cause) {
            case ACTIVATION: 
            case TRAVERSAL: 
            case TRAVERSAL_UP: 
            case TRAVERSAL_DOWN: 
            case TRAVERSAL_FORWARD: 
            case TRAVERSAL_BACKWARD: {
                ButtonGroup buttonGroup;
                ButtonModel buttonModel = this.getModel();
                JToggleButton jToggleButton = this;
                if (buttonModel instanceof DefaultButtonModel && (buttonGroup = ((DefaultButtonModel)buttonModel).getGroup()) != null && buttonGroup.getSelection() != null && !buttonGroup.isSelected(buttonModel)) {
                    Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                    while (enumeration.hasMoreElements()) {
                        AbstractButton abstractButton = enumeration.nextElement();
                        if (!buttonGroup.isSelected(abstractButton.getModel())) continue;
                        if (!(abstractButton instanceof JToggleButton) || !abstractButton.isVisible() || !abstractButton.isDisplayable() || !abstractButton.isEnabled() || !abstractButton.isFocusable()) break;
                        jToggleButton = (JToggleButton)abstractButton;
                        break;
                    }
                }
                return jToggleButton;
            }
        }
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        public AccessibleJToggleButton() {
            super(JToggleButton.this);
            JToggleButton.this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JToggleButton jToggleButton = (JToggleButton)itemEvent.getSource();
            if (JToggleButton.this.accessibleContext != null) {
                if (jToggleButton.isSelected()) {
                    JToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    JToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        @Override
        public boolean isSelected() {
            return (this.stateMask & 2) != 0;
        }

        @Override
        public void setSelected(boolean bl) {
            ButtonGroup buttonGroup = this.getGroup();
            if (buttonGroup != null) {
                buttonGroup.setSelected(this, bl);
                bl = buttonGroup.isSelected(this);
            }
            if (this.isSelected() == bl) {
                return;
            }
            this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        @Override
        public void setPressed(boolean bl) {
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            if (!bl && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int n = 0;
                AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                if (aWTEvent instanceof InputEvent) {
                    n = ((InputEvent)aWTEvent).getModifiers();
                } else if (aWTEvent instanceof ActionEvent) {
                    n = ((ActionEvent)aWTEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n));
            }
        }
    }
}

