/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.util.Vector;
import org.apache.xerces.dom.ASModelImpl;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.dom3.as.DOMASBuilder;
import org.apache.xerces.dom3.as.DOMASException;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.parsers.DOMParserImpl;
import org.apache.xerces.parsers.XMLGrammarCachingConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.ls.LSInput;

public class DOMASBuilderImpl
extends DOMParserImpl
implements DOMASBuilder {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected XSGrammarBucket fGrammarBucket;
    protected ASModelImpl fAbstractSchema;

    public DOMASBuilderImpl() {
        super(new XMLGrammarCachingConfiguration());
    }

    public DOMASBuilderImpl(XMLGrammarCachingConfiguration config) {
        super(config);
    }

    public DOMASBuilderImpl(SymbolTable symbolTable) {
        super(new XMLGrammarCachingConfiguration(symbolTable));
    }

    public DOMASBuilderImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        super(new XMLGrammarCachingConfiguration(symbolTable, grammarPool));
    }

    @Override
    public ASModel getAbstractSchema() {
        return this.fAbstractSchema;
    }

    @Override
    public void setAbstractSchema(ASModel abstractSchema) {
        this.fAbstractSchema = (ASModelImpl)abstractSchema;
        XMLGrammarPool grammarPool = (XMLGrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        if (grammarPool == null) {
            grammarPool = new XMLGrammarPoolImpl();
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
        }
        if (this.fAbstractSchema != null) {
            this.initGrammarPool(this.fAbstractSchema, grammarPool);
        }
    }

    @Override
    public ASModel parseASURI(String uri) throws DOMASException, Exception {
        XMLInputSource source = new XMLInputSource(null, uri, null);
        return this.parseASInputSource(source);
    }

    @Override
    public ASModel parseASInputSource(LSInput is) throws DOMASException, Exception {
        XMLInputSource xis = this.dom2xmlInputSource(is);
        try {
            return this.parseASInputSource(xis);
        }
        catch (XNIException e) {
            Exception ex = e.getException();
            throw ex;
        }
    }

    ASModel parseASInputSource(XMLInputSource is) throws Exception {
        if (this.fGrammarBucket == null) {
            this.fGrammarBucket = new XSGrammarBucket();
        }
        this.initGrammarBucket();
        XMLGrammarCachingConfiguration gramConfig = (XMLGrammarCachingConfiguration)this.fConfiguration;
        gramConfig.lockGrammarPool();
        SchemaGrammar grammar = gramConfig.parseXMLSchema(is);
        gramConfig.unlockGrammarPool();
        ASModelImpl newAsModel = null;
        if (grammar != null) {
            newAsModel = new ASModelImpl();
            this.fGrammarBucket.putGrammar(grammar, true);
            this.addGrammars(newAsModel, this.fGrammarBucket);
        }
        return newAsModel;
    }

    private void initGrammarBucket() {
        this.fGrammarBucket.reset();
        if (this.fAbstractSchema != null) {
            this.initGrammarBucketRecurse(this.fAbstractSchema);
        }
    }

    private void initGrammarBucketRecurse(ASModelImpl currModel) {
        if (currModel.getGrammar() != null) {
            this.fGrammarBucket.putGrammar(currModel.getGrammar());
        }
        int i = 0;
        while (i < currModel.getInternalASModels().size()) {
            ASModelImpl nextModel = (ASModelImpl)currModel.getInternalASModels().elementAt(i);
            this.initGrammarBucketRecurse(nextModel);
            ++i;
        }
    }

    private void addGrammars(ASModelImpl model, XSGrammarBucket grammarBucket) {
        SchemaGrammar[] grammarList = grammarBucket.getGrammars();
        int i = 0;
        while (i < grammarList.length) {
            ASModelImpl newModel = new ASModelImpl();
            newModel.setGrammar(grammarList[i]);
            model.addASModel(newModel);
            ++i;
        }
    }

    private void initGrammarPool(ASModelImpl currModel, XMLGrammarPool grammarPool) {
        Grammar[] grammars = new Grammar[1];
        grammars[0] = currModel.getGrammar();
        if (grammars[0] != null) {
            grammarPool.cacheGrammars(grammars[0].getGrammarDescription().getGrammarType(), grammars);
        }
        Vector modelStore = currModel.getInternalASModels();
        int i = 0;
        while (i < modelStore.size()) {
            this.initGrammarPool((ASModelImpl)modelStore.elementAt(i), grammarPool);
            ++i;
        }
    }
}

