/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.core.BcTimeUtil;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcSortUtil;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilConditionSet;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilCrawl;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

class XfilCrawlConditionPane1
extends FxBorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField crawlNameField = new FxTextField();
    FxTextField directoryField = new FxTextField();
    FxTextField fileExtentionField = new FxTextField();
    XfilConditionSet conditionSet = new XfilConditionSet();

    public XfilCrawlConditionPane1() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.setCenter((Node)this.centerPane);
        this.conditionSet.setupCrawlComboBox(false, "\u5bfe\u8c61\u30af\u30ed\u30fc\u30eb");
        boolean crawlExists = this.conditionSet.crawlComboBox.getItems().size() > 0;
        this.centerPane.addNodeUnit(this.conditionSet.newCheckBoxUnit);
        if (!crawlExists) {
            this.conditionSet.newCheckBox.setSelected(true);
            FxUtil.setDisable(this.conditionSet.newCheckBoxUnit, true, Node.class);
            FxUtil.setDisable(this.conditionSet.crawlUnit, true, Node.class);
            this.setDefault();
        }
        this.conditionSet.newCheckBox.selectedProperty().addListener((ov, oldValue, newValue) -> {
            boolean disable = true;
            if (newValue.booleanValue()) {
                this.setDefault();
            } else if (this.conditionSet.crawlComboBox.getItems().size() > 0) {
                disable = false;
                XfilCrawl crawl2 = (XfilCrawl)this.conditionSet.crawlComboBox.getSelectionModel().getSelectedItem();
                this.crawlNameField.setText(crawl2.name);
                this.directoryField.setText(crawl2.directory);
                this.fileExtentionField.setText(crawl2.fileExtention);
            }
            FxUtil.setDisable(this.conditionSet.crawlUnit, disable, Node.class);
        });
        this.centerPane.addNodeUnit(this.conditionSet.crawlUnit);
        if (crawlExists) {
            ArrayList crawlList = new ArrayList();
            crawlList.addAll(this.conditionSet.crawlComboBox.getItems());
            BcSortUtil.sort(crawlList, false, new Object[]{"startDateTime"});
            XfilCrawl crawlWk = (XfilCrawl)crawlList.get(crawlList.size() - 1);
            this.setfilCrawl(crawlWk);
        }
        this.conditionSet.crawlComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<XfilCrawl>(){

            public void changed(ObservableValue ov, XfilCrawl crawlOld, XfilCrawl crawlnew) {
                XfilCrawlConditionPane1.this.setfilCrawl(crawlnew);
            }
        });
        this.crawlNameField.setPrefColumnCount(100);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().CrawlName.toPlain()), new Node[]{this.crawlNameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.directoryField.setPrefColumnCount(100);
        controlUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().Directory.toPlain()), new Node[]{this.directoryField});
        this.centerPane.addNodeUnit(controlUnit);
        this.fileExtentionField.setPrefColumnCount(100);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().fileExtention), new Node[]{this.fileExtentionField});
        this.centerPane.addNodeUnit(controlUnit);
    }

    protected void setDefault() {
        Calendar now = BcTimeUtil.createCalendar();
        String dateTimeStr = BcTimeUtil.toString(now, "yyyy/MM/dd HH:mm:ss");
        this.crawlNameField.setText(String.valueOf(dateTimeStr) + " \u306e\u30af\u30ed\u30fc\u30eb");
        File[] files = File.listRoots();
        ArrayList<String> driveNameList = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            driveNameList.add(file.getPath());
            ++n2;
        }
        this.directoryField.setText(BcCsvUtil.toCsv(driveNameList));
        this.fileExtentionField.setText(BcCsvUtil.toCsv(XfilConstants.getMovieExtentionList()));
    }

    protected void setfilCrawl(XfilCrawl crawl) {
        this.crawlNameField.setText(crawl.name);
        this.directoryField.setText(crawl.directory);
        this.fileExtentionField.setText(crawl.fileExtention);
    }

    public XfilAnalysisCondition getCondition() throws Exception {
        XfilAnalysisCondition crawlCondition = this.conditionSet.getCondition();
        crawlCondition.crawlName = this.crawlNameField.getText();
        crawlCondition.directory = this.directoryField.getText();
        crawlCondition.fileExtention = this.fileExtentionField.getText();
        return crawlCondition;
    }
}

