/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.log.BcLoggableObject;
import ext.base.util.BcCollectionUtil;
import ext.lib.nlp.NlpNoun;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;

public class OpenNlpUtil
extends BcLoggableObject {
    List<TokenNameFinder> tokenNameFinderList;
    List<NlpNoun> nounList;

    public static OpenNlpUtil getInstance() {
        return SingletonHolder.instance;
    }

    public void setup(List<File> binFileList, List<NlpNoun> nounList) throws Exception {
        this.nounList = nounList;
        this.tokenNameFinderList = new ArrayList<TokenNameFinder>();
        InputStream is = this.getClass().getResourceAsStream("rondhuit-ja-ner-1.0.0.bin");
        TokenNameFinderModel tokenNameFinderModel = new TokenNameFinderModel(is);
        this.tokenNameFinderList.add((TokenNameFinder)new NameFinderME(tokenNameFinderModel));
        if (binFileList != null) {
            int i = 0;
            while (i < binFileList.size()) {
                File binFile = binFileList.get(i);
                FileInputStream fis = new FileInputStream(binFile);
                tokenNameFinderModel = new TokenNameFinderModel((InputStream)fis);
                this.tokenNameFinderList.add((TokenNameFinder)new NameFinderME(tokenNameFinderModel));
                ++i;
            }
        }
        this.getLogger().debug("tokenNameFinderList.size()=" + this.tokenNameFinderList.size());
    }

    public void findName(String[] sentenceArray) throws Exception {
        int i = 0;
        while (i < sentenceArray.length) {
            this.getLogger().debug("sentenceArray[" + i + "]=" + sentenceArray[i]);
            ++i;
        }
        i = 0;
        while (i < this.tokenNameFinderList.size()) {
            TokenNameFinder tokenNameFinder = this.tokenNameFinderList.get(i);
            Span[] spans = tokenNameFinder.find(sentenceArray);
            if (!BcCollectionUtil.isEmpty(spans)) {
                int j = 0;
                while (j < spans.length) {
                    Span span = spans[j];
                    this.getLogger().debug(OpenNlpUtil.createInfo(span, sentenceArray));
                    ++j;
                }
            }
            tokenNameFinder.clearAdaptiveData();
            ++i;
        }
    }

    public static String toString(Span span, String[] sentenceArray) {
        StringBuilder sb = new StringBuilder();
        int i = span.getStart();
        while (i < span.getEnd()) {
            sb.append(sentenceArray[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String createInfo(Span span, String[] sentenceArray) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("type: " + span.getType());
        sb.append(", words: " + OpenNlpUtil.toString(span, sentenceArray));
        return sb.toString();
    }

    private static final class SingletonHolder {
        private static final OpenNlpUtil instance = new OpenNlpUtil();

        private SingletonHolder() {
        }
    }
}

