/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.rmo;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.server.XfilServerUtil;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfQueryTask;
import java.util.ArrayList;
import java.util.Arrays;

public class XfilFileListRMO
extends RmiAbstractRMO {
    String tableName;
    String tableNameAlias;

    public XfilFileListRMO() {
        this.tableNameAlias = this.tableName = XfilConstants.TableName.xfil_entity.name();
    }

    public void fileList(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisCondition = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = XfilServerUtil.getInstance().createDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.parseCondition(dtsSession, selectQuery, analysisCondition);
        this.getFromClause(selectQuery, analysisCondition, this.tableName);
        this.setColumnNameList(sqlContext, selectQuery, analysisCondition);
        this.setOrderByPhrase(sqlContext, selectQuery);
        queryTask.query = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("sql=" + queryTask.query);
        queryTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        SqlWhereElement whereElement;
        SqlWhereElement whereElement2;
        SqlContext sqlContext = dtsSession.getSqlContext();
        if (analysisCondition.crawlId > 0L) {
            SqlWhereElement whereElement3 = new SqlWhereElement();
            whereElement3.setLogical_AND();
            whereElement3.setFormula(String.valueOf(this.tableNameAlias) + ".crawl_id = " + analysisCondition.crawlId);
            selectQuery.addWhereElement(whereElement3);
        }
        ArrayList<SqlWhereElement> whereElementList = new ArrayList<SqlWhereElement>();
        SqlWhereElement whereElement1 = SqlConditionParser.getInstance().parseCondition1(sqlContext, String.valueOf(this.tableNameAlias) + ".directory_", String.valueOf(this.tableNameAlias) + ".directory_", analysisCondition.fileName, null, false);
        if (whereElement1 != null) {
            whereElement1.setLogical_OR();
            whereElementList.add(whereElement1);
        }
        if ((whereElement2 = SqlConditionParser.getInstance().parseCondition1(sqlContext, String.valueOf(this.tableNameAlias) + ".name_", String.valueOf(this.tableNameAlias) + ".name_", analysisCondition.fileName, null, false)) != null) {
            whereElement2.setLogical_OR();
            whereElementList.add(whereElement2);
        }
        if (whereElementList.size() > 0) {
            SqlWhereElement whereElement3 = new SqlWhereElement();
            whereElement3.setLogical_AND();
            whereElement3.setFormula(sqlContext.buildWhereClause(Arrays.asList(whereElement1, whereElement2)));
            selectQuery.addWhereElement(whereElement3);
        }
        if (analysisCondition.isFile) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableNameAlias) + ".child_count < 0");
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.isDirectory) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableNameAlias) + ".child_count >= 0");
            selectQuery.addWhereElement(whereElement);
        }
        SqlConditionParser.getInstance().parseCondition(selectQuery, sqlContext, String.valueOf(this.tableNameAlias) + ".extention_", analysisCondition.fileExtention);
        if (analysisCondition.fileCreationPeriodStart > 0 || analysisCondition.fileCreationPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableNameAlias) + ".creation_datetime", analysisCondition.fileCreationPeriodStart, analysisCondition.fileCreationPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.fileModifiedPeriodStart > 0 || analysisCondition.fileModifiedPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableNameAlias) + ".last_modified_datetime", analysisCondition.fileModifiedPeriodStart, analysisCondition.fileModifiedPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.fileAccessPeriodStart > 0 || analysisCondition.fileAccessPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableNameAlias) + ".last_access_datetime", analysisCondition.fileAccessPeriodStart, analysisCondition.fileAccessPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (!analysisCondition.missingInclude) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableNameAlias) + ".missing_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(analysisCondition.tag)) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(String.valueOf(this.tableNameAlias) + ".text_01" + sqlContext.toKeyword("," + analysisCondition.tag + ","));
            sb.append(")");
            SqlWhereElement whereElement4 = new SqlWhereElement();
            whereElement4.setLogical_AND();
            whereElement4.setFormula(sb.toString());
            selectQuery.addWhereElement(whereElement4);
        }
    }

    public void setColumnNameList(SqlContext sqlContext, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        ArrayList<String> selectColumnNameList = new ArrayList<String>();
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "crawl_id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "drive"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "directory_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "name_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "extention_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "size_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "thumbnail_files"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "width"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "height"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "duration_millis"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "creation_datetime"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "last_modified_datetime"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "add_datetime"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "missing_datetime"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "text_01"));
        selectQuery.getSelectColumnList().addAll(selectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition, String tableName) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlContext sqlContext, SqlSelectQuery selectQuery) throws Exception {
        selectQuery.getOrderByList().add(sqlContext.createTableColumnName(this.tableNameAlias, "directory_"));
        selectQuery.getOrderByList().add(sqlContext.createTableColumnName(this.tableNameAlias, "name_"));
    }

    public static enum Method implements RmiRemoteMethod
    {
        fileList;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

