/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.libx.person.common.PsnPersonConstants;
import ext.libx.person.util.PsnPersonUtil;
import ext.module.wbs1.common.Wbs1Constants;
import ext.module.wbs1.dao.Wbs1PointHeaderDAO;
import ext.module.wbs1.model.Wbs1Account;
import ext.module.wbs1.model.Wbs1PointDetail;
import ext.module.wbs1.model.Wbs1PointHeader;

public class Wbs1PointDetailDAO
extends OrmAbstractDAO<Wbs1PointDetail> {
    private Wbs1PointDetailDAO() {
        super(new Wbs1PointDetail[0]);
        this.setTableName("wbs1_point_detail");
    }

    public static Wbs1PointDetailDAO getInstance() {
        return SingletonHolder.instance;
    }

    public Wbs1PointDetail addPointDetail(DtsSession dtsSession, long personId, Wbs1Constants.PointEvent pointEvent, Object eventValue) throws Exception {
        Wbs1PointDetail pointDetail = new Wbs1PointDetail();
        pointDetail.personId = personId;
        pointDetail.value = pointEvent.value;
        pointDetail.addition = pointEvent.addition;
        pointDetail.eventTypeId = pointEvent.id;
        pointDetail.eventValue = BcStringUtil.toString(eventValue);
        this.putEntity(dtsSession, pointDetail);
        Wbs1PointHeader pointHeader = Wbs1PointHeaderDAO.getInstance().getByPersonIdCreate(dtsSession, personId);
        pointHeader.total = pointDetail.addition ? (pointHeader.total += pointDetail.value) : (pointHeader.total -= pointDetail.value);
        Wbs1PointHeaderDAO.getInstance().putEntity(dtsSession, pointHeader);
        return pointDetail;
    }

    public Wbs1PointDetail addPointDetail(DtsSession dtsSession, Wbs1Account loginAccount, Wbs1Constants.PointEvent pointEvent, Object eventValue) throws Exception {
        if (!PsnPersonUtil.sexEquals(PsnPersonConstants.Sex.female, loginAccount.sexCode)) {
            return this.addPointDetail(dtsSession, loginAccount.personId, pointEvent, eventValue);
        }
        return null;
    }

    public boolean checkPoint(DtsSession dtsSession, long personId, Wbs1Constants.PointEvent pointEvent) throws Exception {
        Wbs1PointHeader pointHeader = Wbs1PointHeaderDAO.getInstance().getByPersonIdCreate(dtsSession, personId);
        int total = pointHeader.total - pointEvent.value;
        return total >= 0;
    }

    public boolean checkPoint(DtsSession dtsSession, Wbs1Account loginAccount, Wbs1Constants.PointEvent pointEvent) throws Exception {
        if (!PsnPersonUtil.sexEquals(PsnPersonConstants.Sex.female, loginAccount.sexCode)) {
            return this.checkPoint(dtsSession, loginAccount.personId, pointEvent);
        }
        return true;
    }

    /* synthetic */ Wbs1PointDetailDAO(Wbs1PointDetailDAO wbs1PointDetailDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1PointDetailDAO instance = new Wbs1PointDetailDAO(null);

        private SingletonHolder() {
        }
    }
}

