/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.fx;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCloneUtil;
import ext.base.util.BcISO;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageUtil;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.libx.fx.international.FxxFlagImageHelper;
import ext.module.xsod.common.XsodConstants;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.common.XsodWords;
import ext.module.xsod.fx.XsodMerchandiseNamePane;
import ext.module.xsod.model.XsodCategory;
import ext.module.xsod.stub.XsodMerchandiseStub;
import ext.scf.client.ScfClientContainer;
import ext.scf2.client.ScfFileUploader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XsodCategoryEditPane
extends FxDecoratePane {
    FxFlowPane flowPane1 = new FxFlowPane(11);
    FxFlowPane flowPane2 = new FxFlowPane(11);
    FxTextField codeField = new FxTextField();
    List<XsodMerchandiseNamePane> namePaneList = new ArrayList<XsodMerchandiseNamePane>();
    FxTextField destFilePathField = new FxTextField();
    FxButton destFileChooseButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    FxBorderPane imageBasePane = new FxBorderPane();
    ScfFileUploader fileUploader;
    Button completionButton;
    Button closeButton;
    XsodCategory merchandiseCategory1;
    XsodCategory merchandiseCategory2;
    public Stage stage;

    public XsodCategoryEditPane() throws Exception {
        this.setComponent1();
        this.setComponent2();
        this.completionButton = this.createButton(BcWords.getInstance().completion);
        this.closeButton = this.createButton(BcWords.getInstance().close);
        this.fileUploader = new ScfFileUploader(ScfClientContainer.getInstance().getAgent());
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponent1() throws Exception {
        this.setCenter((Node)this.flowPane1);
        int i = 0;
        while (i < XsodConstants.langArray.length) {
            BcISO.ISO_639 iso639_1 = XsodConstants.langArray[i];
            XsodMerchandiseNamePane iemTextPane = new XsodMerchandiseNamePane(iso639_1.code);
            this.namePaneList.add(iemTextPane);
            iemTextPane.setPrefSize(600.0, 160.0);
            Image image = FxxFlagImageHelper.getImageByLangCode(iso639_1.code);
            ImageView imageView = new ImageView(image);
            imageView.setImage(image);
            imageView.setFitWidth(32.0);
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            imageView.setCache(true);
            FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(iso639_1.nameJp, (Node)imageView), new Node[]{iemTextPane});
            this.flowPane1.addNodeUnit(nodeUnit);
            ++i;
        }
    }

    protected void setComponent2() throws Exception {
        this.flowPane2.setPrefWidth(600.0);
        this.setRight((Node)this.flowPane2);
        this.codeField.setPrefColumnCount(16);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u5546\u54c1\u30b3\u30fc\u30c9.toString()), new Node[]{this.codeField});
        this.flowPane2.addNodeUnit(nodeUnit);
        this.destFilePathField.setPrefColumnCount(60);
        this.destFileChooseButton.setOnAction(this.actionEventHandler);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("\u753b\u50cf\u9078\u629e"), new Node[]{this.destFilePathField, this.destFileChooseButton});
        this.flowPane2.addNodeUnit(nodeUnit);
        this.imageBasePane.setPrefSize(400.0, 200.0);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("\u753b\u50cf"), new Node[]{this.imageBasePane});
        this.flowPane2.addNodeUnit(nodeUnit);
        ArrayList<String> extentionList = new ArrayList<String>();
        extentionList.addAll(AwtImageUtil.getImageExtentionList());
        FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("\u753b\u50cf\u30d5\u30a1\u30a4\u30eb", extentionList);
        this.fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{extensionFilter});
    }

    protected void setDataId(String merchandiseCategoryCode) throws Exception {
        XsodCategory merchandiseCategory1 = BcStringUtil.isEmpty(merchandiseCategoryCode) ? new XsodCategory() : XsodMerchandiseStub.getInstance().getMerchandiseCategory(merchandiseCategoryCode);
        this.setData(merchandiseCategory1);
    }

    protected void setData(XsodCategory merchandiseCategory) throws Exception {
        this.merchandiseCategory1 = merchandiseCategory;
        this.merchandiseCategory2 = BcCloneUtil.createClone(this.merchandiseCategory1);
        this.codeField.setText(this.merchandiseCategory2.code);
        int i = 0;
        while (i < this.namePaneList.size()) {
            XsodMerchandiseNamePane namePane = this.namePaneList.get(i);
            namePane.clearField();
            String name = XsodUtil.getName(this.merchandiseCategory2, namePane.langCode, false);
            namePane.merchandiseNameField.setText(name);
            ++i;
        }
        this.destFilePathField.setText(this.merchandiseCategory2.imageFileName);
    }

    protected void storeData() throws Exception {
        this.merchandiseCategory2.code = this.codeField.getText();
        int i = 0;
        while (i < this.namePaneList.size()) {
            XsodMerchandiseNamePane namePane = this.namePaneList.get(i);
            XsodUtil.setName(this.merchandiseCategory2, namePane.langCode, namePane.merchandiseNameField.getText());
            ++i;
        }
        if (BcStringUtil.isEmpty(this.destFilePathField.getText())) {
            this.merchandiseCategory2.imageFileName = null;
        } else {
            File imageFile = new File(this.destFilePathField.getText());
            this.merchandiseCategory2.imageFileName = imageFile.getName();
        }
        this.merchandiseCategory2.imageFileName = this.destFilePathField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == ((Object)((Object)this.destFileChooseButton)).hashCode()) {
            FxUtil.initFileChooser(this.fileChooser, this.destFilePathField.getText());
            File file = this.fileChooser.showOpenDialog((Window)this.stage);
            if (file != null) {
                this.destFilePathField.setText(file.getPath());
                URL url = file.toURL();
                Image image = new Image(url.toString());
                ImageView imageView = new ImageView(image);
                this.imageBasePane.setCenter((Node)imageView);
            }
        } else if (ev.getSource() == this.completionButton) {
            this.storeData();
            XsodMerchandiseStub.getInstance().putMerchandiseCategory(this.merchandiseCategory2);
            this.close();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public XsodCategory show(String merchandiseCategoryCode) throws Exception {
        this.setDataId(merchandiseCategoryCode);
        this.stage = new Stage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(1200.0);
        this.stage.setHeight(780.0);
        this.stage.setResizable(true);
        this.stage.setTitle(XsodWords.getInstance().\u5546\u54c1\u7de8\u96c6.toString());
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
        return this.merchandiseCategory2;
    }

    static /* synthetic */ void access$0(XsodCategoryEditPane xsodCategoryEditPane, Throwable throwable) {
        xsodCategoryEditPane.handleException(throwable);
    }
}

