/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileIterator;

public class DirectoryIterator
implements ClassFileIterator {
    private Stack enumStack = new Stack();
    private Enumeration currentEnum;

    public DirectoryIterator(File rootDirectory, boolean changeInto) throws IOException {
        Vector filesInRoot = this.getDirectoryEntries(rootDirectory);
        this.currentEnum = filesInRoot.elements();
    }

    private Vector getDirectoryEntries(File directory) {
        Vector<File> files = new Vector<File>();
        String[] filesInDir = directory.list();
        if (filesInDir != null) {
            int length = filesInDir.length;
            int i = 0;
            while (i < length) {
                files.addElement(new File(directory, filesInDir[i]));
                ++i;
            }
        }
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassFile getNextClassFile() {
        ClassFile nextElement = null;
        try {
            while (true) {
                if (nextElement != null) {
                    return nextElement;
                }
                if (this.currentEnum.hasMoreElements()) {
                    File element = (File)this.currentEnum.nextElement();
                    if (element.isDirectory()) {
                        this.enumStack.push(this.currentEnum);
                        Vector files = this.getDirectoryEntries(element);
                        this.currentEnum = files.elements();
                        continue;
                    }
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (FileInputStream inFileStream = new FileInputStream(element);){
                        if (!element.getName().endsWith(".class")) continue;
                        ClassFile javaClass = new ClassFile();
                        javaClass.read(inFileStream);
                        nextElement = javaClass;
                        continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                if (this.enumStack.empty()) {
                    return nextElement;
                }
                this.currentEnum = (Enumeration)this.enumStack.pop();
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

