/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.lib.swg.SwgCheckBox;
import ext.lib.swg.SwgNumberField;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.swg.SwgTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SwgTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
Serializable {
    private static final long serialVersionUID = -620669358330200611L;
    protected JTable tableView;
    protected int rowId;
    protected int columnId;
    protected MmdField mmdField;
    protected Component currentCompo;
    protected SwgTextField textField = new SwgTextField();
    protected SwgNumberField decimalField = new SwgNumberField(-1, -1, false, "0");
    protected SwgCheckBox checkBox = new SwgCheckBox();
    protected FocusAdapter focusAdapter = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent ev) {
            SwgTableCellEditor.this.tableView.requestFocus();
        }
    };
    protected ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            SwgTableCellEditor.this.actionPerformed1(ev);
        }
    };
    protected Object preValue;

    public SwgTableCellEditor() throws Exception {
        this.decimalField.setNullable(true);
        this.checkBox.addActionListener(this.actionListener);
        this.checkBox.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellEditorComponent(JTable tableView, Object value, boolean isSelected, int rowId, int columnId) {
        this.tableView = tableView;
        this.preValue = value;
        this.rowId = rowId;
        this.columnId = columnId;
        this.mmdField = null;
        Component component = null;
        try {
            component = this.getTableCellEditorComponent_L2(tableView, value, isSelected, rowId, columnId);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            this.textField.setText("error");
            this.textField.selectAll();
            component = this.textField;
        }
        this.setCurrentComponent(component);
        return component;
    }

    public Component getTableCellEditorComponent_L2(JTable tableView, Object cellValue, boolean isSelected, int rowId, int columnId) throws Exception {
        boolean isEditor;
        Component component;
        if (cellValue == null) {
            this.textField.setText(null);
            return this.textField;
        }
        Class<?> valueClass = cellValue.getClass();
        if (Component.class.isAssignableFrom(valueClass)) {
            Component component2 = (Component)cellValue;
            this.setBackground(tableView, component2, isSelected, rowId, columnId);
            return component2;
        }
        TableColumn tableColumn = tableView.getColumnModel().getColumn(columnId);
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass())) {
            BcTableColumn lbTableColumn = (BcTableColumn)tableColumn;
            this.mmdField = lbTableColumn.getMmdField();
        }
        if (this.mmdField == null) {
            BcLogUtil.debug("mmdField Is Null!!!!!!!!!!");
        }
        if ((component = SwgTableViewUtil.getCellComponent_Number(this.mmdField, cellValue, valueClass, isEditor = true, null, this.decimalField, null)) != null) {
            return component;
        }
        component = SwgTableViewUtil.getCellComponent_Calendar(this.mmdField, cellValue, valueClass, isEditor, this.textField, null);
        if (component != null) {
            return component;
        }
        component = SwgTableViewUtil.getCellComponent_Boolean(this.mmdField, cellValue, valueClass, isEditor, true, this.checkBox, null);
        if (component != null) {
            return component;
        }
        component = SwgTableViewUtil.getCellComponent_Text(this.mmdField, cellValue, valueClass, isEditor, this.textField, null);
        return component;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.preValue != null && Component.class.isAssignableFrom(this.preValue.getClass())) {
            return this.getCurrentComponent();
        }
        if (this.mmdField != null && Component.class.isAssignableFrom(this.mmdField.dataClass)) {
            return this.getCurrentComponent();
        }
        if (SwgNumberField.class.isAssignableFrom(this.getCurrentComponent().getClass())) {
            if (BcStringUtil.isEmpty(this.decimalField.getText())) {
                return null;
            }
            Number number = BcNumberUtil.toNumber(this.decimalField.getText(), this.mmdField.dataClass);
            if (number != null) {
                return number;
            }
            return this.decimalField.getText();
        }
        if (SwgTextField.class.isAssignableFrom(this.getCurrentComponent().getClass())) {
            if (BcStringUtil.isEmpty(this.textField.getText())) {
                return null;
            }
            return this.textField.getText();
        }
        if (SwgCheckBox.class.isAssignableFrom(this.getCurrentComponent().getClass())) {
            return this.checkBox.isSelected();
        }
        return this.currentCompo;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    public void setCurrentComponent(Component currentCompo) {
        this.currentCompo = currentCompo;
    }

    public Component getCurrentComponent() {
        return this.currentCompo;
    }

    protected void setBackground(JTable tableView, Component component, boolean isSelected, int rowId, int columnId) {
    }

    protected void actionPerformed1(ActionEvent ev) {
        this.stopCellEditing();
    }
}

