/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcTimeUtil;
import ext.base.util.BcCompareUtil;
import ext.lib.swg.SwgDateField;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgTimeField;
import ext.lib.swg.SwgUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Calendar;

public class SwgDateTimeField
extends SwgPanel {
    private static final long serialVersionUID = 7746080389444141611L;
    public static final int DATE = 1;
    public static final int DATE_TIME = 2;
    public static final int TIME = 3;
    public static final int YEAR_MONTH = 11;
    private int mode;
    public SwgDateField dateField;
    public SwgTimeField timeField;

    public SwgDateTimeField() throws Exception {
        this(2);
    }

    public SwgDateTimeField(int mode) throws Exception {
        this.dateField = this.createDateField(mode);
        this.timeField = this.createTimeField(mode);
        this.setMode(mode);
    }

    public void clear() {
        this.dateField.setText(null);
        this.timeField.setText(null);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.initComponent();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dateField != null) {
            this.dateField.setFont(font);
            this.timeField.setFont(font);
            this.initComponent();
        }
    }

    protected void initComponent() {
        int xPos = 0;
        boolean hDiff = true;
        if (this.mode == 1 || this.mode == 2 || this.mode == 11) {
            SwgUtil.setLocation(this, this.dateField, (double)xPos, 0.0);
            xPos = (int)((double)xPos + (this.dateField.getPreferredSize().getWidth() + (double)hDiff));
        }
        if (this.mode == 3 || this.mode == 2) {
            SwgUtil.setLocation(this, this.timeField, (double)xPos, 0.0);
            xPos = (int)((double)xPos + (this.timeField.getPreferredSize().getWidth() + (double)hDiff));
        }
        this.setPreferredSize(new Dimension(xPos, this.dateField.getPreferredSize().height));
    }

    public void setText(String text) throws Exception {
        Calendar calendar = null;
        try {
            calendar = BcTimeUtil.toCalendar(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (calendar != null) {
            this.dateField.setCalendar(calendar);
            this.timeField.setCalendar(calendar);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.dateField.setEnabled(isEnabled);
        this.timeField.setEnabled(isEnabled);
    }

    public void setEditable(boolean isEditable) {
        this.dateField.setEditable(isEditable);
        this.timeField.setEditable(isEditable);
    }

    public Calendar getCalendar() {
        Calendar dateCalendar = this.dateField.getCalendar();
        Calendar timeCalendar = this.timeField.getCalendar();
        if (dateCalendar != null && timeCalendar != null) {
            BcTimeUtil.copyTimeField(timeCalendar, dateCalendar);
        }
        return dateCalendar;
    }

    public void setCalendar(Calendar calendar) throws Exception {
        this.dateField.setCalendar(calendar);
        this.timeField.setCalendar(calendar);
    }

    public void setCalendar(Integer yyyyMMdd, Short HHmm) throws Exception {
        if (yyyyMMdd == null) {
            this.dateField.setCalendar(null);
        } else {
            this.dateField.setCalendar(BcTimeUtil.toCalendar(yyyyMMdd));
        }
        if (HHmm == null) {
            this.timeField.setCalendar(null);
        } else {
            Calendar calendar = BcTimeUtil.createCalendar();
            BcTimeUtil.setTimeField(calendar, HHmm);
            this.timeField.setCalendar(calendar);
        }
    }

    public SwgDateField createDateField(int mode) throws Exception {
        InnerDateField dateField = null;
        dateField = mode == 11 ? new InnerDateField(mode, "yyyy/MM") : new InnerDateField();
        return dateField;
    }

    public SwgTimeField createTimeField(int mode) throws Exception {
        return new InnerTimeField();
    }

    public void dateUpdated(Calendar oldCalendar, Calendar newCalendar) {
    }

    public void timeUpdated(Calendar oldCalendar, Calendar newCalendar) {
    }

    class InnerDateField
    extends SwgDateField {
        public InnerDateField(int mode, String format) throws Exception {
            super(mode, format);
        }

        public InnerDateField() throws Exception {
        }

        @Override
        public void setText(String text) {
            Calendar preCalendar = this.getCalendar();
            super.setText(text);
            if (BcTimeUtil.compare(preCalendar, this.getCalendar()) != BcCompareUtil.Comparison.equals.value) {
                SwgDateTimeField.this.dateUpdated(preCalendar, this.getCalendar());
            }
        }
    }

    class InnerTimeField
    extends SwgTimeField {
        @Override
        public void setText(String text) {
            Calendar preCalendar = this.getCalendar();
            super.setText(text);
            if (BcTimeUtil.compare(preCalendar, this.getCalendar()) != BcCompareUtil.Comparison.equals.value) {
                SwgDateTimeField.this.timeUpdated(preCalendar, this.getCalendar());
            }
        }
    }
}

