/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.shape;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class FxShapeUtil {
    private FxShapeUtil() {
    }

    public static void setLine(Line line, double x1, double y1, double x2, double y2) throws Exception {
        line.setStartX(x1);
        line.setStartY(y1);
        line.setEndX(x2);
        line.setEndY(y2);
    }

    public static void setText(Text text, double x1, double y1, double width, double height) throws Exception {
        text.setScaleX(x1);
        text.setScaleY(y1);
        text.setWrappingWidth(width);
        text.setTextAlignment(TextAlignment.JUSTIFY);
        text.setFont(new Font(10.0));
    }

    public static void calcArrow(double[] A, double[] B, double w1, double w2, double h1, double h2, double[] L, double[] R, double[] ML, double[] MR, double[] AL, double[] AR) {
        double Vx = B[0] - A[0];
        double Vy = B[1] - A[1];
        double v = Math.sqrt(Vx * Vx + Vy * Vy);
        double Ux = Vx / v;
        double Uy = Vy / v;
        L[0] = B[0] - Uy * w1 - Ux * h1;
        L[1] = B[1] + Ux * w1 - Uy * h1;
        R[0] = B[0] + Uy * w1 - Ux * h1;
        R[1] = B[1] - Ux * w1 - Uy * h1;
        ML[0] = B[0] - Uy * w2 - Ux * h2;
        ML[1] = B[1] + Ux * w2 - Uy * h2;
        MR[0] = B[0] + Uy * w2 - Ux * h2;
        MR[1] = B[1] - Ux * w2 - Uy * h2;
        AL[0] = A[0] - Uy * w2;
        AL[1] = A[1] + Ux * w2;
        AR[0] = A[0] + Uy * w2;
        AR[1] = A[1] - Ux * w2;
    }

    public static Path createArrow(double[] A, double[] B, double w1, double w2, double h1, double h2, double strokeWidth, Color strokeColor, Color fillColor) throws Exception {
        double[] L = new double[2];
        double[] R = new double[2];
        double[] ML = new double[2];
        double[] MR = new double[2];
        double[] AL = new double[2];
        double[] AR = new double[2];
        FxShapeUtil.calcArrow(A, B, w1, w2, h1, h2, L, R, ML, MR, AL, AR);
        Path path = new Path();
        path.setStrokeWidth(strokeWidth);
        path.setStroke((Paint)strokeColor);
        path.setFill((Paint)fillColor);
        MoveTo moveTo = new MoveTo();
        moveTo.setX(AR[0]);
        moveTo.setY(AR[1]);
        path.getElements().add((Object)moveTo);
        LineTo lineTo = new LineTo();
        lineTo.setX(MR[0]);
        lineTo.setY(MR[1]);
        path.getElements().add((Object)lineTo);
        lineTo = new LineTo();
        lineTo.setX(R[0]);
        lineTo.setY(R[1]);
        path.getElements().add((Object)lineTo);
        lineTo = new LineTo();
        lineTo.setX(B[0]);
        lineTo.setY(B[1]);
        path.getElements().add((Object)lineTo);
        lineTo = new LineTo();
        lineTo.setX(L[0]);
        lineTo.setY(L[1]);
        path.getElements().add((Object)lineTo);
        lineTo = new LineTo();
        lineTo.setX(ML[0]);
        lineTo.setY(ML[1]);
        path.getElements().add((Object)lineTo);
        lineTo = new LineTo();
        lineTo.setX(AL[0]);
        lineTo.setY(AL[1]);
        path.getElements().add((Object)lineTo);
        lineTo = new LineTo();
        lineTo.setX(AR[0]);
        lineTo.setY(AR[1]);
        path.getElements().add((Object)lineTo);
        return path;
    }

    public static Path createArrow(double[] A, double[] B, double w1, double w2, double h1, double h2, double strokeWidth, Color fillColor) throws Exception {
        return FxShapeUtil.createArrow(A, B, w1, w2, h1, h2, strokeWidth, fillColor, fillColor);
    }
}

