/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.StructDescriptor;

public class OracleTypeOPAQUE
extends OracleTypeADT
implements Serializable {
    private static final String CLASS_NAME = OracleTypeOPAQUE.class.getName();
    static final long KOLOFLLB = 1L;
    static final long KOLOFLCL = 2L;
    static final long KOLOFLUB = 4L;
    static final long KOLOFLFX = 8L;
    static final long serialVersionUID = -7279638692691669378L;
    private static final String PUBLIC_XMLTYPE_STRING_VALUE = "PUBLIC.XMLTYPE";
    private static final String SYS_XMLTYPE_STRING_VALUE = "SYS.XMLTYPE";
    private static final String XMLTYPE_STRING_VALUE = "XMLTYPE";
    private static Method XMLTYPE_CREATEXML = null;
    long flagBits;
    long maxLen;

    public OracleTypeOPAQUE(byte[] toid, int vsn, int csi, short csfrm, String fullName, long _flagBits) throws SQLException {
        super(toid, vsn, csi, csfrm, fullName);
        this.flagBits = _flagBits;
        this.flattenedAttrNum = 1;
    }

    public OracleTypeOPAQUE(String name, OracleConnection conn) throws SQLException {
        super(name, (Connection)conn);
    }

    public OracleTypeOPAQUE(OracleTypeADT parent, int idx, OracleConnection conn) throws SQLException {
        super(parent, idx, (Connection)conn);
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (value != null) {
            if (value instanceof OPAQUE) {
                return (OPAQUE)value;
            }
            OpaqueDescriptor desc = this.createOpaqueDescriptor();
            return new OPAQUE(desc, this.connection, value);
        }
        return null;
    }

    @Override
    public int getTypeCode() {
        return 2007;
    }

    @Override
    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        if (anOracleType == null) {
            return false;
        }
        if (!(anOracleType instanceof OracleTypeOPAQUE)) {
            return false;
        }
        OpaqueDescriptor theOtherDesc = (OpaqueDescriptor)anOracleType.getTypeDescriptor();
        return this.descriptor.isInHierarchyOf(theOtherDesc.getName());
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        tdsReader.skipBytes(5);
        this.flagBits = tdsReader.readLong();
        this.maxLen = tdsReader.readLong();
    }

    @Override
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int style, Map objmap) throws SQLException {
        if (pickled_bytes == null) {
            return null;
        }
        if ((pickled_bytes[0] & 0x80) > 0) {
            PickleContext context = new PickleContext(pickled_bytes, offset);
            return this.unpickle81(context, (OPAQUE)container, style, objmap);
        }
        return null;
    }

    @Override
    public byte[] linearize(Datum data) throws SQLException {
        return this.pickle81(data);
    }

    @Override
    protected int pickle81(PickleContext ctx, Datum datum) throws SQLException {
        OPAQUE obj = (OPAQUE)datum;
        byte[] data = obj.getBytesValue();
        int imglen = 0;
        imglen += ctx.writeOpaqueImageHeader(data.length);
        return imglen += ctx.writeData(data);
    }

    OPAQUE unpickle81(PickleContext context, OPAQUE container, int style, Map elemMap) throws SQLException {
        return this.unpickle81datum(context, container, style);
    }

    @Override
    protected Object unpickle81rec(PickleContext context, int style, Map map) throws SQLException {
        byte b = context.readByte();
        Object returnValue = null;
        if (PickleContext.isElementNull(b)) {
            return null;
        }
        context.skipRestOfLength(b);
        switch (style) {
            case 1: {
                returnValue = this.unpickle81datum(context, null);
                break;
            }
            case 2: {
                returnValue = this.unpickle81datum(context, null).toJdbc();
                break;
            }
            case 3: {
                returnValue = new OPAQUE(this.createOpaqueDescriptor(), context.readDataValue(), this.connection);
                break;
            }
            case 9: {
                context.skipDataValue();
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        return returnValue;
    }

    private OPAQUE unpickle81datum(PickleContext context, OPAQUE container) throws SQLException {
        return this.unpickle81datum(context, container, 1);
    }

    private OPAQUE createXml(OPAQUE opaqueObject) throws SQLException {
        if (XMLTYPE_CREATEXML == null) {
            try {
                Class<?> xmltype = Class.forName("oracle.xdb.XMLType");
                XMLTYPE_CREATEXML = xmltype.getMethod("createXML", OPAQUE.class);
            }
            catch (Exception ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
        try {
            OPAQUE result = (OPAQUE)XMLTYPE_CREATEXML.invoke(null, opaqueObject);
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            if (cause instanceof Exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), (Exception)cause).fillInStackTrace();
            }
            throw (Error)cause;
        }
        catch (Exception ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    private OPAQUE unpickle81datum(PickleContext context, OPAQUE container, int style) throws SQLException {
        context.skipBytes(2);
        long length = context.readLength(true) - 2;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "unpickle81datum", "byte[] length = {0}", (String)null, null, (Object)length);
        if (container == null) {
            OPAQUE opaqueObject = new OPAQUE(this.createOpaqueDescriptor(), this.connection, context.readBytes((int)length));
            if (this.typeNameByUser != null ? (this.connection.getVersionNumber() >= 12100 ? this.typeNameByUser.equals(SYS_XMLTYPE_STRING_VALUE) : (this.connection.getVersionNumber() > 10205 ? this.typeNameByUser.equals(PUBLIC_XMLTYPE_STRING_VALUE) : this.typeNameByUser.equals(this.connection.getUserName() + "." + XMLTYPE_STRING_VALUE))) : this.sqlName != null && (this.connection.getVersionNumber() >= 12100 ? this.sqlName.getName().equals(SYS_XMLTYPE_STRING_VALUE) : (this.connection.getVersionNumber() > 10205 ? this.sqlName.getName().equals(PUBLIC_XMLTYPE_STRING_VALUE) : this.sqlName.getName().equals(this.connection.getUserName() + '.' + XMLTYPE_STRING_VALUE)))) {
                return this.createXml(opaqueObject);
            }
            return opaqueObject;
        }
        container.setValue(context.readBytes((int)length));
        return container;
    }

    OpaqueDescriptor createOpaqueDescriptor() throws SQLException {
        if (this.sqlName == null) {
            return new OpaqueDescriptor(this, (Connection)this.connection);
        }
        return OpaqueDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
    }

    public long getMaxLength() throws SQLException {
        return this.maxLen;
    }

    public boolean isTrustedLibrary() throws SQLException {
        return (this.flagBits & 1L) != 0L;
    }

    public boolean isModeledInC() throws SQLException {
        return (this.flagBits & 2L) != 0L;
    }

    public boolean isUnboundedSized() throws SQLException {
        return (this.flagBits & 4L) != 0L;
    }

    public boolean isFixedSized() throws SQLException {
        return (this.flagBits & 8L) != 0L;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        this.connection = conn;
    }
}

