/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpStatusException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;

public class SnmpOidTableSupport
implements SnmpOidTable {
    private Hashtable<String, SnmpOidRecord> oidStore = new Hashtable();
    private String myName;

    public SnmpOidTableSupport(String string) {
        this.myName = string;
    }

    @Override
    public SnmpOidRecord resolveVarName(String string) throws SnmpStatusException {
        SnmpOidRecord snmpOidRecord = this.oidStore.get(string);
        if (snmpOidRecord != null) {
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable name <" + string + "> not found in Oid repository");
    }

    @Override
    public SnmpOidRecord resolveVarOid(String string) throws SnmpStatusException {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
        }
        if (n == 0) {
            string = string.substring(1, string.length());
        }
        Enumeration<SnmpOidRecord> enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            SnmpOidRecord snmpOidRecord = enumeration.nextElement();
            if (!snmpOidRecord.getOid().equals(string)) continue;
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
    }

    public Vector<SnmpOidRecord> getAllEntries() {
        Vector<SnmpOidRecord> vector = new Vector<SnmpOidRecord>();
        Enumeration<SnmpOidRecord> enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public synchronized void loadMib(SnmpOidRecord[] snmpOidRecordArray) {
        try {
            int n = 0;
            while (true) {
                SnmpOidRecord snmpOidRecord = snmpOidRecordArray[n];
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpOidTableSupport.class.getName(), "loadMib", "Load " + snmpOidRecord.getName());
                }
                this.oidStore.put(snmpOidRecord.getName(), snmpOidRecord);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpOidTableSupport)) {
            return false;
        }
        SnmpOidTableSupport snmpOidTableSupport = (SnmpOidTableSupport)object;
        return this.myName.equals(snmpOidTableSupport.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.myName);
    }

    public String getName() {
        return this.myName;
    }
}

