/*
 * Decompiled with CFR 0.152.
 */
package ext.scf6.fx;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbApplicationContext;
import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageUtil;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class JfxAboutPane
extends FxDecoratePane {
    protected ImageView imageView = new ImageView();
    protected FxFlowPane cennterPane = new FxFlowPane(22);
    protected FxLabel appNameLabel = new FxLabel();
    protected Button closeButton;
    protected Stage stage;
    double inset = 8.0;

    public JfxAboutPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        BufferedImage awtImage;
        this.imageView.setPreserveRatio(true);
        this.imageView.setSmooth(true);
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll((Object[])new Node[]{new FxLabel(), this.imageView});
        this.setTop((Node)vbox);
        AfbApplicationContext applicationContext = AfbApplication.getInstance().getApplicationContext();
        this.appNameLabel.setText(String.valueOf(applicationContext.appName) + " Ver." + applicationContext.version);
        this.appNameLabel.setPrefSize(160.0, 26.0);
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.appNameLabel});
        this.cennterPane.addNodeUnit(nodeUnit);
        this.closeButton = FxUtil.createCloseButton();
        this.closeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.closeButton);
        this.setCenter((Node)this.cennterPane);
        this.setPadding(new Insets(this.inset));
        WritableImage image = null;
        File imageDir = new File(AfbApplication.getInstance().toReal("${APP}resource/image/"));
        File file = new File(imageDir, "splash.png");
        if (file.exists() && (awtImage = AwtImageUtil.loadImage(file)) != null) {
            BufferedImage bufferedImage = AwtImageUtil.toBufferedImage(awtImage);
            image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        }
        this.imageView.setImage(image);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    JfxAboutPane.this.closeButton.requestFocus();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        double ww = this.imageView.getImage().getWidth() + this.inset * 2.0 + 20.0;
        double wh = this.imageView.getImage().getHeight() + this.inset * 2.0 + 136.0;
        this.stage.setWidth(ww);
        this.stage.setHeight(wh);
        this.stage.setResizable(false);
        this.stage.setTitle(BcWords.getInstance().aboutThisSoftware);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.showAndWait();
    }
}

