/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.fx;

import ext.appfw.common.AfbApplication;
import ext.base.log.BcLogUtil;
import ext.base.reflect.BcReflectUtil;
import ext.lib.fx.control.FxTabPane;
import ext.lib.fx.layout.FxBorderPane;
import ext.module.xdts.fx.XdtsMenuIF;
import ext.module.xdts.fx.XdtsProfileMenuPane;
import ext.module.xfil.fx.XfilMenuPane;
import ext.module.xsys.common.XsysConstants;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.layout.StackPane;

public class XsysMenuPane
extends FxBorderPane {
    List<String> classNameList = new ArrayList<String>();
    List<XdtsMenuIF> instanceList = new ArrayList<XdtsMenuIF>();

    public XsysMenuPane() throws Exception {
        AfbApplication application = AfbApplication.getInstance();
        if (XsysConstants.Function.DatabaseClient.appName.equals(application.getApplicationContext().appName)) {
            this.classNameList.add(XdtsProfileMenuPane.class.getName());
        }
        if (XsysConstants.Function.MovieFiler.appName.equals(application.getApplicationContext().appName)) {
            this.classNameList.add(XfilMenuPane.class.getName());
        }
        if (this.classNameList.size() == 1) {
            this.setComponant_1();
        } else {
            this.setComponant_TabPane();
        }
        this.start();
    }

    protected void setComponant_1() throws Exception {
        String className = this.classNameList.get(0);
        Class<?> clazz = Class.forName(className);
        XdtsMenuIF menuInterface = (XdtsMenuIF)BcReflectUtil.getInstance(clazz);
        this.instanceList.add(menuInterface);
        this.setCenter((Node)menuInterface);
        this.setPadding(new Insets(8.0));
    }

    protected void setComponant_TabPane() throws Exception {
        FxTabPane tabPane1 = new FxTabPane();
        tabPane1.setSide(Side.TOP);
        int i = 0;
        while (i < this.classNameList.size()) {
            String className = this.classNameList.get(i);
            XdtsMenuIF menuInterface = null;
            try {
                Class<?> clazz = Class.forName(className);
                menuInterface = (XdtsMenuIF)BcReflectUtil.getInstance(clazz);
                this.instanceList.add(menuInterface);
            }
            catch (ClassNotFoundException ex) {
                BcLogUtil.error(ex);
            }
            catch (Exception ex) {
                throw ex;
            }
            Tab tab = new Tab();
            tab.setText(menuInterface.getTitle());
            tab.setGraphic((Node)menuInterface.getImageView());
            tab.setContent((Node)menuInterface);
            tab.setClosable(false);
            tabPane1.getTabs().add((Object)tab);
            ++i;
        }
        if (tabPane1.getTabs().size() > 0) {
            Tab tab = (Tab)tabPane1.getTabs().get(0);
            tabPane1.getSelectionModel().select((Object)tab);
        }
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Object[])new Node[]{tabPane1});
        this.setCenter((Node)stackPane);
        this.setPadding(new Insets(8.0));
    }

    public void setMenu(MenuBar menuBar) throws Exception {
        int i = 0;
        while (i < this.instanceList.size()) {
            XdtsMenuIF menuIF = this.instanceList.get(i);
            menuIF.setMenu(menuBar);
            ++i;
        }
    }

    public void start() throws Exception {
        int i = 0;
        while (i < this.instanceList.size()) {
            XdtsMenuIF menuIF = this.instanceList.get(i);
            menuIF.start();
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }
}

