/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.config.Platform;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;

public class WinRegistryWrapper {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_ITEM_EXIST = 0;
    public static final int ERROR_ITEM_NOTEXIST = 9;
    public static final int MAX_KEY_LENGTH = 255;
    public static final int MAX_VALUE_NAME_LENGTH = 255;
    private static final int OPENED_KEY_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int KEY_WOW64_32KEY = 512;
    public static final int KEY_WOW64_64KEY = 256;

    private static native int[] RegOpenKeyEx(int var0, String var1, int var2);

    private static native int RegCloseKey(int var0);

    private static native int[] RegCreateKeyEx(int var0, String var1);

    private static native int[] RegCreateNoReflectionKey(int var0, String var1);

    private static native int RegDeleteKey(int var0, String var1);

    private static native int RegFlushKey(int var0);

    private static native String RegQueryValueEx(int var0, String var1);

    private static native int RegSetValueEx(int var0, String var1, String var2);

    private static native int RegDeleteValue(int var0, String var1);

    private static native int[] RegQueryInfoKey(int var0);

    private static native String RegEnumKeyEx(int var0, int var1, int var2);

    private static native String RegEnumValue(int var0, int var1, int var2);

    private static native String FindMimeFromData(String var0, byte[] var1);

    private static native String ExpandEnvironmentStrings(String var0);

    private WinRegistryWrapper() {
    }

    private static int WinRegCreateKeyImpl(int n, String string, boolean bl) {
        int[] nArray = !bl ? WinRegistryWrapper.RegCreateKeyEx(n, string) : WinRegistryWrapper.RegCreateNoReflectionKey(n, string);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] == 0) {
            WinRegistryWrapper.RegCloseKey(nArray[0]);
        }
        return nArray[1];
    }

    public static int WinRegCreateKeyEx(int n, String string) {
        return WinRegistryWrapper.WinRegCreateKeyImpl(n, string, false);
    }

    public static int WinRegCreateNoReflectionKey(int n, String string) {
        return WinRegistryWrapper.WinRegCreateKeyImpl(n, string, true);
    }

    public static int WinRegDeleteKey(int n, String string) {
        int n2 = WinRegistryWrapper.RegDeleteKey(n, string);
        if (n2 != 0 && WinRegistryWrapper.WinRegSubKeyExist(n, string)) {
            String[] stringArray = WinRegistryWrapper.WinRegGetSubKeys(n, string, 255);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = string + "\\" + stringArray[i];
                if (string2 == null) continue;
                WinRegistryWrapper.WinRegDeleteKey(n, string2);
            }
            n2 = WinRegistryWrapper.RegDeleteKey(n, string);
        }
        return n2;
    }

    public static int WinRegFlushKey(int n, String string) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131078);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] != 0) {
            return nArray[1];
        }
        int n2 = WinRegistryWrapper.RegFlushKey(nArray[0]);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return n2;
    }

    public static String WinRegQueryValueEx(int n, String string, String string2, int n2) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, n2);
        if (nArray != null && nArray[1] == 0) {
            String string3 = WinRegistryWrapper.RegQueryValueEx(nArray[0], string2);
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return string3;
        }
        return null;
    }

    public static String WinRegQueryValueEx(int n, String string, String string2) {
        return WinRegistryWrapper.WinRegQueryValueEx(n, string, string2, 131097);
    }

    public static int WinRegSetValueEx(int n, String string, String string2, String string3) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 2);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] != 0) {
            return nArray[1];
        }
        int n2 = WinRegistryWrapper.RegSetValueEx(nArray[0], string2, string3);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return n2;
    }

    public static int WinRegDeleteValue(int n, String string, String string2) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131078);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] != 0) {
            return nArray[1];
        }
        int n2 = WinRegistryWrapper.RegDeleteValue(nArray[0], string2);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return n2;
    }

    public static int[] WinRegQueryInfoKey(int n, String string) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131097);
        if (nArray != null && nArray[1] == 0) {
            int[] nArray2 = WinRegistryWrapper.RegQueryInfoKey(nArray[0]);
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return nArray2;
        }
        return nArray;
    }

    public static String WinRegEnumKeyEx(int n, String string, int n2, int n3, int n4) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, n4);
        if (nArray != null && nArray[1] == 0) {
            String string2 = WinRegistryWrapper.RegEnumKeyEx(nArray[0], n2, n3);
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return string2;
        }
        return null;
    }

    public static String WinRegEnumKeyEx(int n, String string, int n2, int n3) {
        return WinRegistryWrapper.WinRegEnumKeyEx(n, string, n2, n3, 131097);
    }

    public static String WinRegEnumValue(int n, String string, int n2, int n3) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131097);
        if (nArray != null && nArray[1] == 0) {
            String string2 = WinRegistryWrapper.RegEnumValue(nArray[0], n2, n3);
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return string2;
        }
        return null;
    }

    public static String[] WinRegGetSubKeys(int n, String string, int n2) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131097);
        if (nArray != null && nArray[1] == 0) {
            int[] nArray2 = WinRegistryWrapper.RegQueryInfoKey(nArray[0]);
            int n3 = nArray2[0];
            if (n3 == 0) {
                WinRegistryWrapper.RegCloseKey(nArray[0]);
                return null;
            }
            String[] stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = WinRegistryWrapper.RegEnumKeyEx(nArray[0], i, n2);
            }
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return stringArray;
        }
        return null;
    }

    public static String[] WinRegGetValues(int n, String string, int n2) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131097);
        if (nArray != null && nArray[1] == 0) {
            int[] nArray2 = WinRegistryWrapper.RegQueryInfoKey(nArray[0]);
            int n3 = nArray2[2];
            if (n3 == 0) {
                WinRegistryWrapper.RegCloseKey(nArray[0]);
                return null;
            }
            String[] stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = WinRegistryWrapper.RegEnumValue(nArray[0], i, n2);
            }
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return stringArray;
        }
        return null;
    }

    public static boolean WinRegSubKeyExist(int n, String string) {
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131097);
        if (nArray != null && nArray[1] == 0) {
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return true;
        }
        return false;
    }

    public static int WinRegValueExist(int n, String string, String string2) {
        if (string.trim().equals("")) {
            return 9;
        }
        int[] nArray = WinRegistryWrapper.RegOpenKeyEx(n, string, 131097);
        if (nArray != null && nArray[1] == 0) {
            String string3 = WinRegistryWrapper.RegQueryValueEx(nArray[0], string2);
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return string3 != null ? 0 : 9;
        }
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String WinFindMimeFromData(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        String string2 = WinRegistryWrapper.FindMimeFromData(string, null);
        if (string2 != null) {
            return string2;
        }
        byte[] byArray = new byte[256];
        DataInputStream dataInputStream = null;
        dataInputStream = new DataInputStream(uRL.openStream());
        dataInputStream.read(byArray, 0, 256);
        dataInputStream.close();
        Object var8_5 = null;
        if (dataInputStream == null) return WinRegistryWrapper.FindMimeFromData(null, byArray);
        try {
            dataInputStream.close();
            return WinRegistryWrapper.FindMimeFromData(null, byArray);
        }
        catch (IOException iOException) {}
        return WinRegistryWrapper.FindMimeFromData(null, byArray);
        {
            catch (IOException iOException) {
                String string3 = null;
                Object var8_6 = null;
                if (dataInputStream == null) return string3;
                try {
                    dataInputStream.close();
                    return string3;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (dataInputStream == null) throw throwable;
            try {
                dataInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String WinExpandEnvironmentStrings(String string) {
        return WinRegistryWrapper.ExpandEnvironmentStrings(string);
    }

    static {
        Platform.get().loadDeployNativeLib();
    }
}

