/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.selectors.TokenizedPattern;
import org.apache.tools.ant.util.FileUtils;

public final class SelectorUtils {
    public static final String DEEP_TREE_MATCH = "**";
    private static final SelectorUtils instance = new SelectorUtils();
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    private SelectorUtils() {
    }

    public static SelectorUtils getInstance() {
        return instance;
    }

    public static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str, true);
    }

    public static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        String[] patDirs = SelectorUtils.tokenizePathAsArray(pattern);
        String[] strDirs = SelectorUtils.tokenizePathAsArray(str);
        return SelectorUtils.matchPatternStart(patDirs, strDirs, isCaseSensitive);
    }

    static boolean matchPatternStart(String[] patDirs, String[] strDirs, boolean isCaseSensitive) {
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strDirs.length - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            String patDir = patDirs[patIdxStart];
            if (patDir.equals(DEEP_TREE_MATCH)) break;
            if (!SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern, String str) {
        String[] patDirs = SelectorUtils.tokenizePathAsArray(pattern);
        return SelectorUtils.matchPath(patDirs, SelectorUtils.tokenizePathAsArray(str), true);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        String[] patDirs = SelectorUtils.tokenizePathAsArray(pattern);
        return SelectorUtils.matchPath(patDirs, SelectorUtils.tokenizePathAsArray(str), isCaseSensitive);
    }

    /*
     * Unable to fully structure code
     */
    static boolean matchPath(String[] tokenizedPattern, String[] strDirs, boolean isCaseSensitive) {
        patIdxStart = 0;
        patIdxEnd = tokenizedPattern.length - 1;
        strIdxStart = 0;
        strIdxEnd = strDirs.length - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            patDir = tokenizedPattern[patIdxStart];
            if (patDir.equals("**")) break;
            if (!SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            i = patIdxStart;
            while (i <= patIdxEnd) {
                if (!tokenizedPattern[i].equals("**")) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxStart <= patIdxEnd) ** GOTO lbl28
        return false;
        while (!(patDir = tokenizedPattern[patIdxEnd]).equals("**")) {
            if (!SelectorUtils.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl28:
            // 2 sources

            if (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) continue;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl70
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!tokenizedPattern[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (tokenizedPattern[i].equals("**")) {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block19: {
                    j = 0;
                    while (j < patLength) {
                        subPat = tokenizedPattern[patIdxStart + j + 1];
                        subStr = strDirs[strIdxStart + i + j];
                        if (SelectorUtils.match(subPat, subStr, isCaseSensitive)) {
                            ++j;
                            continue;
                        }
                        break block19;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl70:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl71:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!tokenizedPattern[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str, true);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean match(String pattern, String str, boolean caseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?' && SelectorUtils.different(caseSensitive, ch, strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && SelectorUtils.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return SelectorUtils.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && SelectorUtils.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl76
        return SelectorUtils.allStars(patArr, patIdxStart, patIdxEnd);
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block20: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || !SelectorUtils.different(caseSensitive, ch, strArr[strIdxStart + i + j])) {
                            ++j;
                            continue;
                        }
                        break block20;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl76:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl77:
        // 1 sources

        return SelectorUtils.allStars(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(char[] chars, int start, int end) {
        int i = start;
        while (i <= end) {
            if (chars[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    public static Vector<String> tokenizePath(String path) {
        return SelectorUtils.tokenizePath(path, File.separator);
    }

    public static Vector<String> tokenizePath(String path, String separator) {
        Vector<String> ret = new Vector<String>();
        if (FileUtils.isAbsolutePath(path)) {
            String[] s = FILE_UTILS.dissect(path);
            ret.add(s[0]);
            path = s[1];
        }
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.addElement(st.nextToken());
        }
        return ret;
    }

    static String[] tokenizePathAsArray(String path) {
        String root = null;
        if (FileUtils.isAbsolutePath(path)) {
            String[] s = FILE_UTILS.dissect(path);
            root = s[0];
            path = s[1];
        }
        char sep = File.separatorChar;
        int start = 0;
        int len = path.length();
        int count = 0;
        int pos = 0;
        while (pos < len) {
            if (path.charAt(pos) == sep) {
                if (pos != start) {
                    ++count;
                }
                start = pos + 1;
            }
            ++pos;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count + (root == null ? 0 : 1)];
        if (root != null) {
            l[0] = root;
            count = 1;
        } else {
            count = 0;
        }
        start = 0;
        int pos2 = 0;
        while (pos2 < len) {
            if (path.charAt(pos2) == sep) {
                if (pos2 != start) {
                    String tok = path.substring(start, pos2);
                    l[count++] = tok;
                }
                start = pos2 + 1;
            }
            ++pos2;
        }
        if (len != start) {
            String tok;
            l[count] = tok = path.substring(start);
        }
        return l;
    }

    public static boolean isOutOfDate(File src, File target, int granularity) {
        if (!src.exists()) {
            return false;
        }
        if (!target.exists()) {
            return true;
        }
        return src.lastModified() - (long)granularity > target.lastModified();
    }

    public static boolean isOutOfDate(Resource src, Resource target, int granularity) {
        return SelectorUtils.isOutOfDate(src, target, (long)granularity);
    }

    public static boolean isOutOfDate(Resource src, Resource target, long granularity) {
        long sourceLastModified = src.getLastModified();
        long targetLastModified = target.getLastModified();
        return src.isExists() && (sourceLastModified == 0L || targetLastModified == 0L || sourceLastModified - granularity > targetLastModified);
    }

    public static String removeWhitespace(String input) {
        StringBuffer result = new StringBuffer();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result.append(st.nextToken());
            }
        }
        return result.toString();
    }

    public static boolean hasWildcards(String input) {
        return input.indexOf(42) != -1 || input.indexOf(63) != -1;
    }

    public static String rtrimWildcardTokens(String input) {
        return new TokenizedPattern(input).rtrimWildcardTokens().toString();
    }
}

