/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.base.core.BcTimeUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.EtcSqlUtil;
import ext.lib.task.TskAbstractCallable;
import ext.module.xfil.common.XfilCaptureParam;
import ext.module.xfil.common.XfilCaptureUtil;
import ext.module.xfil.common.XfilCaptureUtil2;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilAnalysisResult;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilVCaptureCondition;
import ext.module.xfil.server.SnapshotTask;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class XfilCaptureTask
extends TskAbstractCallable {
    DtsSession dtsSessionWk;
    XfilAnalysisCondition capturingConditionB;
    XfilVCaptureCondition captureCondition;
    XfilAnalysisResult analysisResult;
    XfilUriEntityDAO uriEntitydao;
    long crawlId;

    public void setCondition(DtsSession dtsSessionWk, XfilAnalysisCondition capturingConditionB, XfilVCaptureCondition captureCondition, XfilUriEntityDAO uriEntitydao, long crawlId) {
        this.dtsSessionWk = dtsSessionWk;
        this.capturingConditionB = capturingConditionB;
        this.captureCondition = captureCondition;
        this.uriEntitydao = uriEntitydao;
        this.crawlId = crawlId;
    }

    public Object taskProcess() throws Exception {
        try {
            Object object = this.taskProcess_L2();
            return object;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            EtcSqlUtil.closeSession(this.dtsSessionWk, this.getLogger());
        }
    }

    public Object taskProcess_L2() throws Exception {
        XfilUriEntity uriEntity;
        this.getLogger().debug("doClear=" + this.capturingConditionB.doClear);
        if (this.capturingConditionB.doClear) {
            this.initThumbnail();
        }
        while (true) {
            if ((uriEntity = (XfilUriEntity)this.uriEntitydao.getForCreateThumbnail(this.dtsSessionWk)) == null) break;
            try {
                this.proc1(uriEntity);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        this.getLogger().debug("#uriEntity=" + uriEntity);
        return null;
    }

    public void proc1(XfilUriEntity uriEntity) throws Exception {
        XfilCaptureParam videoCaptureParam1 = XfilCaptureUtil.convert(this.captureCondition);
        XfilCaptureParam videoCaptureParam2 = XfilCaptureUtil.adjustment(videoCaptureParam1, uriEntity.durationMillis);
        File dir = XfilUtil.getTthumbnailsDir(uriEntity.id);
        XfilCaptureUtil2.getInstance().proc1(uriEntity, videoCaptureParam2, dir);
        this.uriEntitydao.putEntity(this.dtsSessionWk, uriEntity);
        this.dtsSessionWk.commit();
    }

    protected void initThumbnail() throws Exception {
        long entityId = -1L;
        List uriEntityList = this.uriEntitydao.getList(this.dtsSessionWk, XfilUriEntityDAO.Mode.id, entityId, this.crawlId, null, null, null, -1, false);
        this.getLogger().info("\u30d5\u30a1\u30a4\u30eb\u6570=" + uriEntityList.size());
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
            uriEntity.thumbnailDatetime = null;
            uriEntity.error2 = null;
            ++i;
        }
        this.getLogger().info("\u6c38\u7d9a\u5316\u4e2d...");
        this.uriEntitydao.putEntityCollection(this.dtsSessionWk, uriEntityList);
        this.dtsSessionWk.commit();
    }

    public void snapshotOrig(XfilUriEntity uriEntity) throws Exception {
        File imputFile = XfilUtil.toFile(uriEntity);
        SnapshotTask snapshotTask = new SnapshotTask();
        URI uri = XfilUtil.toUri(uriEntity);
        snapshotTask.setCondition(uri.toString(), this.capturingConditionB);
        File dir = XfilUtil.getTthumbnailsDir(uriEntity.id);
        snapshotTask.setCondition(uriEntity, dir, this.crawlId);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future future = executorService.submit(snapshotTask);
        Object res = future.get();
        uriEntity.thumbnailDatetime = BcTimeUtil.createCalendar();
    }
}

