/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.stub;

import ext.base.mmd.MmdModel;
import ext.base.table.BcTableModel;
import ext.base.thread.BcMonitor;
import ext.base.util.BcResult;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.lib.sql.context.SqlTableMetadata;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.XdtsSchemaObject;
import ext.module.xdts.model.XsysCompareCondition;
import ext.module.xdts.rmo.XdtsSchemaRMO;
import ext.module.xmmd.model.XmmdModel;
import ext.scf.client.ScfClientContainer;
import ext.scf4.fx.HfxProcessingPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.stage.Window;

public final class XdtsSchemaStub {
    private XdtsSchemaStub() {
    }

    public static XdtsSchemaStub getInstance() {
        return SingletonHolder.instance;
    }

    public List<String> getTableNameList(int profileId) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("getTableNameList");
        rmiReq.addData(profileId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        List tableNameList = (List)rmiRes.getData();
        return tableNameList;
    }

    public List<String> getViewNameList(int profileId) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("getViewNameList");
        rmiReq.addData(profileId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        List tableNameList = (List)rmiRes.getData();
        return tableNameList;
    }

    public Map getMmdModelMap(int profileId, Collection<String> tableNameCollection) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("getMmdModelMap");
        rmiReq.addData(profileId);
        rmiReq.addData(tableNameCollection);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        Map mmdMap = (Map)rmiRes.getData();
        return mmdMap;
    }

    public MmdModel getModelMetaData(int profileId, String tableName) throws Exception {
        ArrayList<String> tableNameList = new ArrayList<String>();
        tableNameList.add(tableName);
        Map mmdMap = this.getMmdModelMap(profileId, tableNameList);
        return (MmdModel)mmdMap.get(tableName);
    }

    public Map<String, XmmdModel> getXmmdModelMap(int profileId, Collection<String> tableNameCollection) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("getXmmdModelMap");
        rmiReq.addData(profileId);
        rmiReq.addData(tableNameCollection);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        Map xmmdMap = (Map)rmiRes.getData();
        return xmmdMap;
    }

    public Map<String, SqlTableMetadata> getTableMetadataMap(int profileId, Collection<String> tableNameCollection) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("getTableMetadataMap");
        rmiReq.addData(profileId);
        rmiReq.addData(tableNameCollection);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        Map tableMetadataMap = (Map)rmiRes.getData();
        return tableMetadataMap;
    }

    public Object updateQuery(XdtsProcessCondition processCondition, String title, Window ownerWindow) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("updateQuery");
        rmiReq.addData(processCondition);
        HfxProcessingPane processingPane = new HfxProcessingPane();
        processingPane.setRequest(rmiReq);
        processingPane.show(title, ownerWindow);
        return null;
    }

    public Object createCrateTableSql(XdtsProcessCondition processCondition, String title) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("createCrateTableSql");
        rmiReq.addData(processCondition);
        HfxProcessingPane processingPane = new HfxProcessingPane();
        processingPane.setRequest(rmiReq);
        processingPane.show(title, null);
        return null;
    }

    public Object createInsertSql(XdtsProcessCondition processCondition, String title, Window ownerWindow) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("createInsertSql");
        rmiReq.addData(processCondition);
        HfxProcessingPane processingPane = new HfxProcessingPane();
        processingPane.setRequest(rmiReq);
        processingPane.show(title, ownerWindow);
        return null;
    }

    public Object copyToOther(XdtsProcessCondition processCondition, String title, Window ownerWindow) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("copyToOther");
        rmiReq.addData(processCondition);
        HfxProcessingPane processingPane = new HfxProcessingPane();
        processingPane.setRequest(rmiReq);
        processingPane.show(title, ownerWindow);
        return null;
    }

    public BcTableModel countSize(int profileId, List<XdtsSchemaObject> schemaObjectList, Window window) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("countSize");
        rmiReq.addData(profileId);
        rmiReq.addData(schemaObjectList);
        BcMonitor monitor = new BcMonitor();
        HfxProcessingPane processingPane = new HfxProcessingPane();
        processingPane.setRequest(rmiReq);
        processingPane.successfullyMessageEnable = false;
        processingPane.show(XdtsWords.getInstance().numberOfRows_size.toPlain(), window, true);
        RmiRespons rmiRes = processingPane.getResponse();
        BcTableModel tableModel = (BcTableModel)rmiRes.getData();
        return tableModel;
    }

    public Object[] schemaCompare(XsysCompareCondition compareCondition, Window window) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsSchemaRMO.class.getName());
        rmiReq.setMethodName("compareSchema");
        rmiReq.addData(compareCondition);
        BcMonitor monitor = new BcMonitor();
        HfxProcessingPane processingPane = new HfxProcessingPane();
        processingPane.setRequest(rmiReq);
        processingPane.successfullyMessageEnable = false;
        processingPane.show(XdtsWords.getInstance().compareSchemas.toPlain(), window, true);
        RmiRespons rmiRes = processingPane.getResponse();
        BcResult result = (BcResult)rmiRes.getData();
        BcTableModel tableTable = (BcTableModel)rmiRes.getData();
        BcTableModel viewTable = (BcTableModel)rmiRes.getData();
        Map tableFieldMap = (Map)rmiRes.getData();
        Map viewFieldMap = (Map)rmiRes.getData();
        Object[] res = new Object[]{result, tableTable, viewTable, tableFieldMap, viewFieldMap};
        return res;
    }

    /* synthetic */ XdtsSchemaStub(XdtsSchemaStub xdtsSchemaStub) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsSchemaStub instance = new XdtsSchemaStub(null);

        private SingletonHolder() {
        }
    }
}

