/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.module.xdts.common.XdtsWordXmlCreator;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.rmo.XdtsWordRMO;
import ext.scf.client.ScfClientContainer;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class Z_XdtsWordXmlImportPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField filePathField = new FxTextField();
    FxButton fileChooseButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    Button completionButton;
    Button cancelButton;
    XdtsProfile profile;
    static final int MODE_export = 1;
    static final int MODE_import = 2;
    int mode;
    String title;
    Stage stage;

    public Z_XdtsWordXmlImportPane(int mode) throws Exception {
        this.mode = mode;
        switch (mode) {
            case 1: {
                this.title = XdtsWords.getInstance().exportLogicalNameXml;
                break;
            }
            case 2: {
                this.title = XdtsWords.getInstance().importLogicalNameXml;
            }
        }
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.completionButton = this.createButton(BcWords.getInstance().completion);
        this.cancelButton = this.createButton(BcWords.getInstance().close);
        this.filePathField.setPrefColumnCount(80);
        this.fileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("XML"), new Node[]{this.filePathField, this.fileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.filePathField.getText());
            File file = null;
            file = this.mode == 1 ? this.fileChooser.showSaveDialog((Window)this.stage) : this.fileChooser.showOpenDialog((Window)this.stage);
            if (file != null) {
                this.filePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.completionButton) {
            switch (this.mode) {
                case 1: {
                    this.exportAction();
                    break;
                }
                case 2: {
                    this.importAction();
                }
            }
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    protected void exportAction() throws Exception {
        XdtsWordXmlCreator wordXmlCreator = new XdtsWordXmlCreator();
        this.close();
    }

    protected void importAction() throws Exception {
        File targetFile = new File(this.filePathField.getText());
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsWordRMO.class.getName());
        rmiReq.setMethodName("wordXmlImport");
        rmiReq.addData(this.profile.getDataId());
        rmiReq.addData(targetFile);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        this.close();
    }

    public void close() throws Exception {
        this.stage.close();
    }

    public void show(XdtsProfile profile, Window ownerWindow) throws Exception {
        this.profile = profile;
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    Z_XdtsWordXmlImportPane.this.close();
                }
                catch (Exception ex) {
                    Z_XdtsWordXmlImportPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(400.0);
        this.stage.setResizable(true);
        this.stage.setTitle(this.title);
        this.stage.getIcons().add((Object)FxImageHelper.getImage("import_64x64.png"));
        this.stage.showAndWait();
    }
}

