/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.JMSMessageI;
import oracle.jdbc.driver.JMSMessagePropertiesI;
import oracle.jdbc.driver.KeywordValueI;
import oracle.jdbc.driver.KeywordValueLongI;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.XSAttributeI;
import oracle.jdbc.driver.XSKeyvalI;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.driver.XSPrincipalI;
import oracle.jdbc.driver.XSSecureIdI;
import oracle.jdbc.driver.XSSessionNamespaceI;
import oracle.jdbc.driver.XSSessionParametersI;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.XSAttribute;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.internal.XSSecurityPermission;
import oracle.jdbc.internal.XSSessionNamespace;
import oracle.jdbc.internal.XSSessionParameters;

public final class InternalFactory {
    private static final String PERMISSION_NAME = "callJdbcXS";
    private static final XSSecurityPermission XS_SECURITY_PERMISSION = new XSSecurityPermission("callJdbcXS");

    private InternalFactory() {
        throw new RuntimeException("Cannot be instantiated");
    }

    static void xsSecurityCheck() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(XS_SECURITY_PERMISSION);
        }
    }

    public static XSAttribute createXSAttribute() throws SQLException {
        InternalFactory.xsSecurityCheck();
        return new XSAttributeI();
    }

    public static XSNamespace createXSNamespace() throws SQLException {
        InternalFactory.xsSecurityCheck();
        return new XSNamespaceI();
    }

    public static XSSecureId createXSecureId() throws SQLException {
        InternalFactory.xsSecurityCheck();
        return new XSSecureIdI();
    }

    public static XSPrincipal createXSPrincipal() throws SQLException {
        InternalFactory.xsSecurityCheck();
        return new XSPrincipalI();
    }

    public static XSKeyval createXSKeyval() throws SQLException {
        InternalFactory.xsSecurityCheck();
        return new XSKeyvalI();
    }

    public static XSSessionNamespace createXSSessionNamespace() throws SQLException {
        InternalFactory.xsSecurityCheck();
        return new XSSessionNamespaceI();
    }

    public static XSSessionParameters createXSSessionParameters() throws SQLException {
        InternalFactory.xsSecurityCheck();
        return new XSSessionParametersI();
    }

    public static KeywordValue createKeywordValue(int keyword, String value, byte[] binaryvalue) throws SQLException {
        return new KeywordValueI(keyword, value, binaryvalue);
    }

    public static KeywordValueLong createKeywordValueLong(int keyword, String value, byte[] binaryvalue) throws SQLException {
        return new KeywordValueLongI(keyword, value, binaryvalue);
    }

    public static AQMessageProperties createAQMessageProperties() throws SQLException {
        return new AQMessagePropertiesI();
    }

    public static AQAgent createAQAgent() throws SQLException {
        return new AQAgentI();
    }

    public static AQMessage createAQMessage(AQMessageProperties prop) throws SQLException {
        return new AQMessageI((AQMessagePropertiesI)prop);
    }

    public static JMSMessage createJMSMessage(JMSMessageProperties jmsMessageProperties) {
        return new JMSMessageI((JMSMessagePropertiesI)jmsMessageProperties);
    }

    public static JMSMessageProperties createJMSMessageProperties() throws SQLException {
        return new JMSMessagePropertiesI();
    }

    public static byte[] urowid2rowid(long[] rowid) {
        return T4CRowidAccessor.rowidToString(rowid);
    }

    public static long[] rowid2urowid(byte[] rowid, int offset, int length) throws SQLException {
        return T4CRowidAccessor.stringToRowid(rowid, offset, length);
    }
}

