/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.fx;

import ext.appfw.common.AfbApplication;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.xml.BcXmlUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.http.client.HtclContentLoader;
import ext.lib.task.TskAbstractCallable;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.fx.XsodAbstractSignage;
import ext.module.xsod.fx.XsodController;
import ext.module.xsod.fx.XsodSignageController;
import ext.module.xsod.model.XsodMerchandise;
import ext.module.xsod.model.XsodMerchandisePack;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import org.w3c.dom.Document;

public class XsodSignagePane
extends FxBorderPane {
    StackPane stackPane = new StackPane();
    List<String> classNameList = new ArrayList<String>();
    BcMonitor monitor = new BcMonitor();
    int classIndex = -1;

    public XsodSignagePane() throws Exception {
        this.setCenter((Node)this.stackPane);
        Document dom = XsodController.getInstance().dom;
        org.w3c.dom.Node node_signage = BcXmlUtil.getNode(dom, "signage");
        if (node_signage == null) {
            String msg = "XML\u306b signage \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
            throw new Exception(msg);
        }
        List<org.w3c.dom.Node> domNodeList1 = BcXmlUtil.getNodeList(node_signage, (short)1);
        BcLogUtil.debug("domNodeList1.size()=" + domNodeList1.size());
        int i = 0;
        while (i < domNodeList1.size()) {
            org.w3c.dom.Node domNode1 = domNodeList1.get(i);
            BcLogUtil.debug("domNode1.getNodeName()=" + domNode1.getNodeName());
            if (domNode1.getNodeName().equals("class")) {
                BcLogUtil.debug("domNode1.getNodeValue()=" + BcXmlUtil.getTextValue(domNode1));
                this.classNameList.add(BcXmlUtil.getTextValue(domNode1));
            }
            ++i;
        }
        InnerTask innerTask = new InnerTask();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future response = executorService.submit(innerTask);
    }

    public void finished() throws Exception {
        this.monitor.unLock();
    }

    public void setup() throws Exception {
        File dataDir = new File(AfbApplication.getInstance().toReal("${APP}data/"));
        File jsonFile = new File(dataDir, "signage.json");
        URL getUrl = new URL(String.valueOf(XsodSignageController.getInstance().baseUrl) + "getSignageData");
        BcLogUtil.info("\u30b5\u30a4\u30cd\u30fc\u30b8\u30c7\u30fc\u30bf\u3092\u53d6\u5f97\u4e2d... URL=" + getUrl);
        HtclContentLoader contentLoader = new HtclContentLoader();
        try {
            ByteArrayOutputStream baos = contentLoader.getContent(getUrl);
            byte[] bytes = baos.toByteArray();
            BcLogUtil.info("JSON\u3092\u89e3\u6790\u4e2d... \u30b5\u30a4\u30ba=" + bytes.length);
            XsodSignageController.getInstance().signageData = XsodUtil.toSignageData(bytes);
            BcLogUtil.info("\u30b5\u30a4\u30cd\u30fc\u30b8\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u4e2d...");
            BcFileUtil.save(jsonFile, bytes);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        if (XsodSignageController.getInstance().signageData == null) {
            BcLogUtil.info("\u30ed\u30fc\u30ab\u30ebJSON\u3092\u89e3\u6790\u4e2d... " + jsonFile.getPath());
            XsodSignageController.getInstance().signageData = XsodUtil.getSignageData(jsonFile);
            BcLogUtil.info("\u5546\u54c1\u6570=" + XsodSignageController.getInstance().signageData.merchandisePackList.size());
        }
        BcLogUtil.info("\u30ea\u30bd\u30fc\u30b9\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d...");
        File imageDir = new File(dataDir, "images");
        BcFileUtil.mkdirs(imageDir, new FileAttribute[0]);
        int i = 0;
        while (i < XsodSignageController.getInstance().signageData.merchandisePackList.size()) {
            XsodMerchandisePack merchandisePack = XsodSignageController.getInstance().signageData.merchandisePackList.get(i);
            XsodMerchandise merchandise = merchandisePack.merchandise;
            BcLogUtil.info("\u753b\u50cfURL=" + merchandisePack.imageUrl);
            try {
                URL imageUrl = new URL(String.valueOf(XsodSignageController.getInstance().baseUrl) + merchandisePack.imageUrl);
                ByteArrayOutputStream baos = contentLoader.getContent(imageUrl);
                File imageFile = new File(imageDir, merchandise.imageFileName);
                BcFileUtil.save(imageFile, baos.toByteArray());
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }

    class InnerTask
    extends TskAbstractCallable {
        InnerTask() {
        }

        public Object taskProcess() throws Exception {
            while (true) {
                XsodSignagePane.this.monitor.sync();
                ++XsodSignagePane.this.classIndex;
                if (XsodSignagePane.this.classIndex >= XsodSignagePane.this.classNameList.size()) {
                    XsodSignagePane.this.classIndex = 0;
                }
                XsodSignagePane.this.setup();
                String className = XsodSignagePane.this.classNameList.get(XsodSignagePane.this.classIndex);
                Class<?> clazz = Class.forName(className);
                Object oblect = clazz.newInstance();
                final XsodAbstractSignage signage = (XsodAbstractSignage)oblect;
                signage.setSignagePane(XsodSignagePane.this);
                signage.init();
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Node node = signage.getNode();
                            ((InnerTask)InnerTask.this).XsodSignagePane.this.stackPane.getChildren().clear();
                            ((InnerTask)InnerTask.this).XsodSignagePane.this.stackPane.getChildren().add((Object)node);
                        }
                        catch (Exception ex) {
                            BcLogUtil.error(ex);
                        }
                    }
                });
                XsodSignagePane.this.monitor.lock();
            }
        }
    }
}

