/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.ConnectionDesc;
import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PoolCallback;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;

final class Connections
implements PoolCallback {
    private static final boolean debug = Pool.debug;
    private static final boolean trace = LdapPoolManager.trace;
    private static final int DEFAULT_SIZE = 10;
    private final int initSize;
    private final int maxSize;
    private final int prefSize;
    private final List<ConnectionDesc> conns;
    private final PooledConnectionFactory factory;
    private boolean closed = false;
    private Reference<Object> ref;
    private boolean initialized = false;
    private final ReentrantLock lock;
    private final Condition connectionsAvailable;

    Connections(Object object, int n, int n2, int n3, PooledConnectionFactory pooledConnectionFactory, ReentrantLock reentrantLock) throws NamingException {
        this.maxSize = n3;
        this.lock = reentrantLock;
        this.connectionsAvailable = reentrantLock.newCondition();
        this.factory = pooledConnectionFactory;
        if (n3 > 0) {
            this.prefSize = Math.min(n2, n3);
            this.initSize = Math.min(n, n3);
        } else {
            this.prefSize = n2;
            this.initSize = n;
        }
        this.conns = new ArrayList<ConnectionDesc>(n3 > 0 ? n3 : 10);
        this.initialized = n <= 0;
        this.ref = new SoftReference<Object>(object);
        this.d("init size=", n);
        this.d("max size=", n3);
        this.d("preferred size=", n2);
    }

    void waitForAvailableConnection() throws InterruptedNamingException {
        try {
            this.d("get(): waiting");
            this.connectionsAvailable.await();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedNamingException("Interrupted while waiting for a connection");
        }
    }

    void waitForAvailableConnection(long l) throws InterruptedNamingException {
        try {
            this.d("get(): waiting");
            this.connectionsAvailable.await(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedNamingException("Interrupted while waiting for a connection");
        }
    }

    PooledConnection getAvailableConnection(long l) throws NamingException {
        if (!this.initialized) {
            PooledConnection pooledConnection = this.createConnection(this.factory, l);
            if (this.conns.size() >= this.initSize) {
                this.initialized = true;
            }
            return pooledConnection;
        }
        int n = this.conns.size();
        if (this.prefSize <= 0 || n >= this.prefSize) {
            for (ConnectionDesc connectionDesc : this.conns) {
                ConnectionDesc connectionDesc2 = connectionDesc;
                PooledConnection pooledConnection = connectionDesc2.tryUse();
                if (pooledConnection == null) continue;
                this.d("get(): use ", pooledConnection);
                this.td("Use ", pooledConnection);
                return pooledConnection;
            }
        }
        return null;
    }

    PooledConnection createConnection(PooledConnectionFactory pooledConnectionFactory, long l) throws NamingException {
        int n = this.conns.size();
        if (this.maxSize == 0 || n < this.maxSize) {
            PooledConnection pooledConnection = pooledConnectionFactory.createPooledConnection(this, l);
            this.td("Create and use ", pooledConnection, pooledConnectionFactory);
            this.conns.add(new ConnectionDesc(pooledConnection, true));
            return pooledConnection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releasePooledConnection(PooledConnection pooledConnection) {
        this.lock.lock();
        try {
            ConnectionDesc connectionDesc = new ConnectionDesc(pooledConnection);
            int n = this.conns.indexOf(connectionDesc);
            this.d("release(): ", pooledConnection);
            if (n >= 0) {
                if (this.closed || this.prefSize > 0 && this.conns.size() > this.prefSize) {
                    this.d("release(): closing ", pooledConnection);
                    this.td("Close ", pooledConnection);
                    this.conns.remove(connectionDesc);
                    pooledConnection.closeConnection();
                } else {
                    this.d("release(): release ", pooledConnection);
                    this.td("Release ", pooledConnection);
                    connectionDesc = this.conns.get(n);
                    connectionDesc.release();
                }
                this.connectionsAvailable.signalAll();
                this.d("release(): notify");
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    @Override
    public boolean removePooledConnection(PooledConnection pooledConnection) {
        this.lock.lock();
        try {
            if (this.conns.remove(new ConnectionDesc(pooledConnection))) {
                this.d("remove(): ", pooledConnection);
                this.connectionsAvailable.signalAll();
                this.d("remove(): notify");
                this.td("Remove ", pooledConnection);
                if (this.conns.isEmpty()) {
                    this.ref = null;
                }
                boolean bl = true;
                return bl;
            }
            this.d("remove(): not found ", pooledConnection);
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean expire(long l) {
        ArrayList<ConnectionDesc> arrayList;
        this.lock.lock();
        try {
            arrayList = new ArrayList<ConnectionDesc>(this.conns);
        }
        finally {
            this.lock.unlock();
        }
        ArrayList<ConnectionDesc> arrayList2 = new ArrayList<ConnectionDesc>();
        for (ConnectionDesc connectionDesc : arrayList) {
            this.d("expire(): ", connectionDesc);
            if (!connectionDesc.expire(l)) continue;
            arrayList2.add(connectionDesc);
            this.td("expire(): Expired ", connectionDesc);
        }
        this.lock.lock();
        try {
            this.conns.removeAll(arrayList2);
            boolean bl = this.conns.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    synchronized void close() {
        this.expire(System.currentTimeMillis());
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStats() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        Connections connections = this;
        synchronized (connections) {
            n = this.conns.size();
            block8: for (int i = 0; i < n; ++i) {
                ConnectionDesc connectionDesc = this.conns.get(i);
                l += connectionDesc.getUseCount();
                switch (connectionDesc.getState()) {
                    case 0: {
                        ++n3;
                        continue block8;
                    }
                    case 1: {
                        ++n2;
                        continue block8;
                    }
                    case 2: {
                        ++n4;
                    }
                }
            }
        }
        return "size=" + n + "; use=" + l + "; busy=" + n3 + "; idle=" + n2 + "; expired=" + n4;
    }

    boolean grabLock(long l) throws InterruptedNamingException {
        long l2;
        long l3 = l2 = System.nanoTime();
        boolean bl = false;
        for (long i = l; !bl && i > 0L; i -= TimeUnit.NANOSECONDS.toMillis(l3 - l2)) {
            try {
                bl = this.lock.tryLock(i, TimeUnit.MILLISECONDS);
                i -= TimeUnit.NANOSECONDS.toMillis(l3 - l2);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted while waiting for the connection pool lock");
            }
            l3 = System.nanoTime();
        }
        return bl;
    }

    void unlock() {
        this.lock.unlock();
    }

    private void d(String string, Object object) {
        if (debug) {
            this.d(string + object);
        }
    }

    private void d(String string, int n) {
        if (debug) {
            this.d(string + n);
        }
    }

    private void d(String string) {
        if (debug) {
            System.err.println(this + "." + string + "; size: " + this.conns.size());
        }
    }

    private void td(String string, Object object, Object object2) {
        if (trace) {
            this.td(string + object + "[" + object2 + "]");
        }
    }

    private void td(String string, Object object) {
        if (trace) {
            this.td(string + object);
        }
    }

    private void td(String string) {
        if (trace) {
            System.err.println(string);
        }
    }
}

