/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Visitor;

public class LocalVariableTypeTable
extends Attribute {
    private LocalVariable[] local_variable_type_table;

    public LocalVariableTypeTable(LocalVariableTypeTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTypeTable(), c.getConstantPool());
    }

    public LocalVariableTypeTable(int name_index, int length, LocalVariable[] local_variable_table, ConstantPool constant_pool) {
        super((byte)17, name_index, length, constant_pool);
        this.local_variable_type_table = local_variable_table;
    }

    LocalVariableTypeTable(int nameIdx, int len, DataInput input, ConstantPool cpool) throws IOException {
        this(nameIdx, len, (LocalVariable[])null, cpool);
        int local_variable_type_table_length = input.readUnsignedShort();
        this.local_variable_type_table = new LocalVariable[local_variable_type_table_length];
        int i = 0;
        while (i < local_variable_type_table_length) {
            this.local_variable_type_table[i] = new LocalVariable(input, cpool);
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariableTypeTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.local_variable_type_table.length);
        LocalVariable[] localVariableArray = this.local_variable_type_table;
        int n = this.local_variable_type_table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable variable = localVariableArray[n2];
            variable.dump(file);
            ++n2;
        }
    }

    public final LocalVariable[] getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public final LocalVariable getLocalVariable(int index) {
        LocalVariable[] localVariableArray = this.local_variable_type_table;
        int n = this.local_variable_type_table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable variable = localVariableArray[n2];
            if (variable.getIndex() == index) {
                return variable;
            }
            ++n2;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] local_variable_table) {
        this.local_variable_type_table = local_variable_table;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.local_variable_type_table.length) {
            buf.append(this.local_variable_type_table[i].toStringShared(true));
            if (i < this.local_variable_type_table.length - 1) {
                buf.append('\n');
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        LocalVariableTypeTable c = (LocalVariableTypeTable)this.clone();
        c.local_variable_type_table = new LocalVariable[this.local_variable_type_table.length];
        int i = 0;
        while (i < this.local_variable_type_table.length) {
            c.local_variable_type_table[i] = this.local_variable_type_table[i].copy();
            ++i;
        }
        c.setConstantPool(constant_pool);
        return c;
    }

    public final int getTableLength() {
        return this.local_variable_type_table == null ? 0 : this.local_variable_type_table.length;
    }
}

