/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.fx;

import ext.base.core.BcStringUtil;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.util.FxEffectUtil;
import ext.lib.fx.util.FxImageUtil;
import ext.lib.fx.util.FxUtil;
import ext.module.xsod.common.FxxImageCash;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.common.XsodWords;
import ext.module.xsod.fx.XsodController;
import ext.module.xsod.fx.XsodUiFactory;
import ext.module.xsod.model.XsodMenuData;
import ext.module.xsod.model.XsodMerchandisePack;
import ext.module.xsod.model.XsodOrder;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class XsodOrderRowPane
extends FxBorderPane {
    public static final int MODE_plan = 1;
    public static final int MODE_fix = 2;
    int mode;
    int xSpace = 6;
    double image_w;
    double image_h;
    ImageView imageView = new ImageView();
    Text merchandiseNameText = new Text();
    Button plusButton;
    Text quantityText = new Text();
    Button minusButton;
    XsodOrder order;

    public XsodOrderRowPane(int mode) throws Exception {
        this.mode = mode;
        switch (mode) {
            case 1: {
                this.setComponent_plan();
                break;
            }
            case 2: {
                this.setComponent_fix();
            }
        }
    }

    protected void setComponent_plan() throws Exception {
        this.image_h = this.image_w = XsodUiFactory.getInstance().orderPlanRowHeight - 24.0;
        double itemName_w = 190.0;
        double plus_w = XsodUiFactory.getInstance().orderPlanRowHeight - (double)this.xSpace;
        double quantity_w = 34.0;
        double x = this.xSpace;
        double y = 0.0;
        double yAdd = (XsodUiFactory.getInstance().orderPlanRowHeight - this.image_h) / 2.0;
        this.imageView.setFitWidth(this.image_w);
        this.imageView.setPreserveRatio(true);
        this.imageView.setSmooth(true);
        this.imageView.setCache(true);
        FxUtil.setLocation((Pane)this, (Node)this.imageView, x, y + yAdd, this.image_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        x += this.image_w;
        x += (double)this.xSpace;
        this.merchandiseNameText.setFont(XsodUiFactory.getInstance().orderPlanFont);
        this.merchandiseNameText.setTextAlignment(TextAlignment.LEFT);
        this.merchandiseNameText.setFill((Paint)Color.BLACK);
        this.merchandiseNameText.setStrokeWidth(1.0);
        this.merchandiseNameText.setStroke((Paint)Color.BLACK);
        yAdd = 30.0;
        FxUtil.setLocation((Pane)this, (Node)this.merchandiseNameText, x, y + yAdd, itemName_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        x += itemName_w;
        this.plusButton = new Button(XsodWords.getInstance().\u30d7\u30e9\u30b9.toString());
        this.plusButton.setOnAction(this.actionEventHandler);
        this.plusButton.setFont(XsodUiFactory.getInstance().defaultFont);
        FxUtil.setLocation((Pane)this, (Control)this.plusButton, x += (double)this.xSpace, y, plus_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        x += plus_w;
        x += (double)this.xSpace;
        this.quantityText.setFont(XsodUiFactory.getInstance().defaultFont);
        this.quantityText.setTextAlignment(TextAlignment.RIGHT);
        this.quantityText.setFill((Paint)Color.BLACK);
        this.quantityText.setStrokeWidth(1.0);
        this.quantityText.setStroke((Paint)Color.BLACK);
        yAdd = 30.0;
        FxUtil.setLocation((Pane)this, (Node)this.quantityText, x, y + yAdd, quantity_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        x += quantity_w;
        this.minusButton = new Button(XsodWords.getInstance().\u30de\u30a4\u30ca\u30b9.toString());
        this.minusButton.setOnAction(this.actionEventHandler);
        this.minusButton.setFont(XsodUiFactory.getInstance().defaultFont);
        FxUtil.setLocation((Pane)this, (Control)this.minusButton, x += (double)this.xSpace, y, plus_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        this.setEffect((Effect)FxEffectUtil.createDropShadow());
    }

    protected void setComponent_fix() throws Exception {
        this.image_h = this.image_w = XsodUiFactory.getInstance().orderPlanRowHeight - 24.0;
        double itemName_w = 300.0;
        double plus_w = XsodUiFactory.getInstance().orderPlanRowHeight - (double)this.xSpace;
        double quantity_w = 34.0;
        double x = this.xSpace;
        double y = 0.0;
        double yAdd = (XsodUiFactory.getInstance().orderPlanRowHeight - this.image_h) / 2.0;
        this.imageView.setFitWidth(this.image_w);
        this.imageView.setPreserveRatio(true);
        this.imageView.setSmooth(true);
        this.imageView.setCache(true);
        FxUtil.setLocation((Pane)this, (Node)this.imageView, x, y + yAdd, this.image_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        x += this.image_w;
        x += (double)this.xSpace;
        this.merchandiseNameText.setFont(XsodUiFactory.getInstance().orderPlanFont);
        this.merchandiseNameText.setTextAlignment(TextAlignment.LEFT);
        this.merchandiseNameText.setFill((Paint)Color.BLACK);
        this.merchandiseNameText.setStrokeWidth(1.0);
        this.merchandiseNameText.setStroke((Paint)Color.BLACK);
        yAdd = 30.0;
        FxUtil.setLocation((Pane)this, (Node)this.merchandiseNameText, x, y + yAdd, itemName_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        x += itemName_w;
        x += (double)this.xSpace;
        this.quantityText.setFont(XsodUiFactory.getInstance().defaultFont);
        this.quantityText.setTextAlignment(TextAlignment.RIGHT);
        this.quantityText.setFill((Paint)Color.BLACK);
        this.quantityText.setStrokeWidth(1.0);
        this.quantityText.setStroke((Paint)Color.BLACK);
        yAdd = 30.0;
        FxUtil.setLocation((Pane)this, (Node)this.quantityText, x, y + yAdd, quantity_w, XsodUiFactory.getInstance().orderPlanRowHeight);
        x += quantity_w;
        x += (double)this.xSpace;
        this.setEffect((Effect)FxEffectUtil.createDropShadow());
    }

    public void setData(XsodOrder order) throws Exception {
        this.order = order;
        XsodMenuData menuData = XsodController.getInstance().getMenuData();
        XsodMerchandisePack merchandisePack = XsodUtil.getMerchandisePackByItemCode(menuData, order.merchandiseCode);
        String merchandiseName = XsodUtil.getName(merchandisePack.merchandise, XsodController.getInstance().langCode, true);
        this.merchandiseNameText.setText(merchandiseName);
        Image image = FxxImageCash.getInstance().getImageNI(merchandisePack.merchandise.imageFileName);
        if (image != null) {
            this.imageView.setImage(image);
            FxImageUtil.setSizeExtract(this.imageView, this.image_w, this.image_h);
        }
        this.update();
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.plusButton) {
            ++this.order.quantity;
            this.update();
        } else if (ev.getSource() == this.minusButton && this.order.quantity > 0) {
            --this.order.quantity;
            this.update();
        }
    }

    protected void update() throws Exception {
        String str = BcStringUtil.fillPrefix(this.order.quantity, 2, ' ');
        this.quantityText.setText(str);
    }
}

