/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.common;

import ext.base.core.BcInteger;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.util.BcEncoder;
import ext.base.util.BcParseEventHandler;
import ext.lib.poi.PoiConstants;
import ext.libx.etc.util.EtcPoiUtil;
import ext.module.impt.common.ImptAbstractRecordParser;
import ext.module.impt.common.ImptImportDataParser;
import ext.module.impt.common.ImptWorkbookParser;
import ext.module.impt.model.ImptImportDefine;
import ext.module.impt.model.ImptMapper;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public final class ImptImportUtil {
    private ImptImportUtil() {
    }

    public static ImptImportUtil getInstance() {
        return SingletonHolder.instance;
    }

    public int toDatasourceType(String fileExtention) throws Exception {
        String fileExtention2 = BcStringUtil.toLowerCase(fileExtention);
        if (PoiConstants.Extention.csv.name().equals(fileExtention2) || PoiConstants.Extention.tsv.name().equals(fileExtention2)) {
            return 11;
        }
        if (PoiConstants.Extention.xls.name().equals(fileExtention2) || PoiConstants.Extention.xlsx.name().equals(fileExtention2)) {
            return 31;
        }
        return -1;
    }

    public int toDatasourceTypeByFileName(String fileNme) throws Exception {
        String fileExtention = BcFileUtil.getExtention(fileNme);
        return this.toDatasourceType(fileExtention);
    }

    public ImptAbstractRecordParser createParser(int datasourceType) throws Exception {
        ImptAbstractRecordParser parser = null;
        switch (datasourceType) {
            case 11: {
                parser = new ImptImportDataParser();
                break;
            }
            case 31: {
                parser = new ImptWorkbookParser();
            }
        }
        return parser;
    }

    public List<String> parseFixdText(ImptImportDefine importDefine, BcEncoder encoder, byte[] bytes) throws Exception {
        BcInteger offSet = new BcInteger();
        offSet.value = 0;
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < importDefine.getModelMetaDataFieldCount()) {
            MmdField mmdField = importDefine.getModelMetaDataField(i);
            byte[] bytes2 = new byte[mmdField.dataSize];
            System.arraycopy(bytes, offSet.value, bytes2, 0, bytes2.length);
            try {
                String strVal = null;
                if (encoder != null) {
                    encoder.charMap.entrySet();
                    for (Map.Entry<Character, byte[]> mapEntry : encoder.charMap.entrySet()) {
                        byte[] value = mapEntry.getValue();
                        if (!Arrays.equals(bytes2, value)) continue;
                        strVal = Character.toString(mapEntry.getKey().charValue());
                        BcLogUtil.debug("### hit:strVal=" + strVal);
                    }
                }
                if (strVal == null) {
                    strVal = BcStringUtil.isEmpty(importDefine.charsetName) ? new String(bytes2) : new String(bytes2, importDefine.charsetName);
                }
                valueList.add(BcStringUtil.toNull(strVal));
                offSet.value += mmdField.dataSize;
            }
            catch (UnsupportedEncodingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw ex;
            }
            ++i;
        }
        return valueList;
    }

    public Calendar perseTime(ImptMapper mapper, String srcStr, String defaultParseFormat, ImptImportDefine importDefine) throws Exception {
        int year;
        if (BcStringUtil.isEmpty(srcStr)) {
            return null;
        }
        String srcStr2 = srcStr;
        String parseFormat = null;
        if (!BcStringUtil.isEmpty(defaultParseFormat)) {
            parseFormat = defaultParseFormat;
        }
        if ((year = BcNumberUtil.parseInteger(mapper.props.getProperty("year", "-1")).intValue()) > 0) {
            if (srcStr2.indexOf("-") >= 0) {
                srcStr2 = srcStr2.substring(0, srcStr2.indexOf("-"));
            }
            srcStr2 = String.valueOf(Integer.toString(year)) + "/" + srcStr2;
        } else if (!BcStringUtil.isEmpty(mapper.mmdField.formatPattern)) {
            parseFormat = mapper.mmdField.formatPattern;
        }
        Calendar calendar = null;
        if (importDefine.datasourceType == 31) {
            try {
                int n = BcNumberUtil.parseInteger(srcStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (calendar == null) {
            try {
                calendar = !BcStringUtil.isEmpty(parseFormat) ? BcTimeUtil.toCalendar(srcStr2, parseFormat) : BcTimeUtil.toCalendar(srcStr2);
            }
            catch (Exception ex) {
                throw new Exception(String.valueOf(mapper.mmdField.fieldName) + " '" + srcStr2 + "' \u304c\u65e5\u6642\u3068\u3057\u3066\u8b58\u5225\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        }
        return calendar;
    }

    public Calendar perseTime(ImptMapper mapper, String srcStr, ImptImportDefine importDefine) throws Exception {
        return this.perseTime(mapper, srcStr, null, importDefine);
    }

    public void nonLineNumberLog(Object logObj) {
        BcLogUtil.debug(logObj);
    }

    public boolean doseUpdate(int updateModeId, Object oldValue, Object newValue) throws Exception {
        boolean doUpdate = false;
        switch (updateModeId) {
            case 2: {
                doUpdate = BcStringUtil.isEmpty(oldValue);
                break;
            }
            case 3: {
                doUpdate = !BcStringUtil.isEmpty(newValue);
                break;
            }
            case 4: {
                doUpdate = true;
            }
        }
        return doUpdate;
    }

    public boolean doseUpdate(int updateModeId, int oldValue, int newValue) throws Exception {
        boolean doUpdate = false;
        switch (updateModeId) {
            case 2: {
                doUpdate = oldValue <= 0;
                break;
            }
            case 3: {
                doUpdate = newValue > 0;
                break;
            }
            case 4: {
                doUpdate = true;
            }
        }
        return doUpdate;
    }

    public static void addMmdField(ImptImportDefine importDefine, List<? extends CharSequence> columnNameList) throws Exception {
        int i = 0;
        while (i < columnNameList.size()) {
            CharSequence columnName = columnNameList.get(i);
            MmdField mmdField = EtcPoiUtil.createMmdFieldForCSV(columnName);
            importDefine.addModelMetaDataField(mmdField);
            ++i;
        }
        importDefine.packData();
    }

    public static void addMmdField(ImptImportDefine importDefine, CharSequence ... columnNames) throws Exception {
        List<CharSequence> columnNameList = Arrays.asList(columnNames);
        ImptImportUtil.addMmdField(importDefine, columnNameList);
    }

    public BcTableModel csvToTable(ImptImportDefine importDefine, InputStream is) throws Exception {
        BcTableModel tableModel = new BcTableModel();
        InnerCsvParser csvParser = new InnerCsvParser(importDefine, tableModel);
        csvParser.doParse(importDefine, is);
        return tableModel;
    }

    public BcTableModel csvToTable(InputStream is) throws Exception {
        ImptImportDefine importDefine = new ImptImportDefine();
        importDefine.datasourceType = 11;
        return this.csvToTable(importDefine, is);
    }

    /* synthetic */ ImptImportUtil(ImptImportUtil imptImportUtil) {
        this();
    }

    class InnerCsvParser
    extends ImptImportDataParser
    implements BcParseEventHandler {
        ImptImportDefine importDefine;
        BcTableColumnModel tableColumnModel;
        BcTableModel tableModel;

        public InnerCsvParser(ImptImportDefine importDefine, BcTableModel tableModel) {
            this.importDefine = importDefine;
            this.tableModel = tableModel;
            this.tableColumnModel = tableModel.getTableColumnModel();
        }

        @Override
        public void parseStarted() throws Exception {
        }

        @Override
        public void parseFinished() throws Exception {
        }

        @Override
        public void parsedRow(int page, int rowNumber, int totalCnt, List<String> valueList) throws Exception {
            if (this.importDefine.headerRow > 0 && rowNumber < this.importDefine.headerRow) {
                BcLogUtil.info("\u884c " + rowNumber + " \u306f\u30d8\u30c3\u30c0\u884c\u6307\u5b9a " + this.importDefine.headerRow + " \u3088\u308a\u3082\u524d\u306e\u305f\u3081\u3001\u8aad\u307f\u6368\u3066\u307e\u3059\u3002");
                return;
            }
            if (rowNumber == this.importDefine.headerRow) {
                EtcPoiUtil.addColumnNameForCSV(this.tableColumnModel, valueList);
                return;
            }
            int gap = valueList.size() - this.tableColumnModel.getColumnCount();
            if (gap > 0) {
                int i = 0;
                while (i < gap) {
                    MmdField mmdField = EtcPoiUtil.createMmdFieldForCSV(Integer.toString(this.tableColumnModel.getColumnCount() + 1));
                    BcTableColumn tableColumn = new BcTableColumn(this.tableColumnModel.getColumnCount());
                    tableColumn.setMmdField(mmdField);
                    this.tableColumnModel.addColumn(tableColumn);
                    ++i;
                }
            }
            ArrayList<String> valueList2 = new ArrayList<String>();
            valueList2.addAll(valueList);
            this.tableModel.addRow(valueList2);
        }

        @Override
        public void characterDecodingException(int page, int row, int totalCnt, int columnIndex, byte[] bytes, Throwable throwable) throws Exception {
            BcLogUtil.error(throwable);
        }
    }

    private static final class SingletonHolder {
        private static final ImptImportUtil instance = new ImptImportUtil(null);

        private SingletonHolder() {
        }
    }
}

