/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.html.util;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcHtmlConverter;
import ext.base.util.BcWordPack;
import ext.lib.html.common.HtmlBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class EtcHtmlUtil {
    static HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
    static BcHtmlConverter htmlConverter = new BcHtmlConverter();

    private EtcHtmlUtil() {
    }

    public static String connectBrTag(Collection elemCollection, boolean htmlTag, boolean isCenter) {
        StringBuilder sb = new StringBuilder();
        for (Object element : elemCollection) {
            if (element == null) continue;
            if (!BcStringUtil.isEmpty(sb)) {
                sb.append(htmlBuilder.br());
            }
            sb.append(element.toString());
        }
        if (isCenter) {
            sb = new StringBuilder(htmlBuilder.center(sb.toString()));
        }
        if (htmlTag) {
            sb = new StringBuilder(htmlBuilder.html(sb.toString(), false));
        }
        return sb.toString();
    }

    public static String connectBrTag(boolean htmlTag, boolean isCenter, String ... strs) {
        return EtcHtmlUtil.connectBrTag(Arrays.asList(strs), htmlTag, isCenter);
    }

    public static String connectBrTag(boolean htmlTag, String ... strs) {
        return EtcHtmlUtil.connectBrTag(htmlTag, false, strs);
    }

    public static String connectBrTagCenter(Collection elemCollection) {
        return EtcHtmlUtil.connectBrTag(elemCollection, true, true);
    }

    public static String connectBrTagCenter(String ... strs) {
        return EtcHtmlUtil.connectBrTagCenter(Arrays.asList(strs));
    }

    public static List<String> toStringList(CharSequence charSequence) throws Exception {
        List<String> strList = null;
        strList = EtcHtmlUtil.isHtml(charSequence.toString()) ? htmlConverter.toPlainList(charSequence, true) : MmdUtil.splitTableColumnName(charSequence.toString());
        return strList;
    }

    public static boolean isHtml(String str1) {
        String str2 = BcStringUtil.trim(str1);
        if (BcStringUtil.isEmpty(str2)) {
            return false;
        }
        HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
        String str3 = str2.toUpperCase();
        return str3.startsWith(htmlBuilder.html_start(false).toUpperCase());
    }

    public static String toHtml(BcWordPack wordPack) {
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.html_start(false));
        sb.append(EtcHtmlUtil.toHtml2(wordPack));
        sb.append(htmlBuilder.html_end());
        return sb.toString();
    }

    protected static String toHtml2(BcWordPack wordPack) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < wordPack.objects.length) {
            Object object = wordPack.objects[i];
            if (i > 0 && !wordPack.connect) {
                sb.append(htmlBuilder.br());
            }
            if (object instanceof BcWordPack) {
                BcWordPack wordPack2 = (BcWordPack)object;
                sb.append(EtcHtmlUtil.toHtml2(wordPack2));
            } else {
                sb.append(BcStringUtil.toStringNotNull(object));
            }
            ++i;
        }
        if (BcStringUtil.isEmpty(sb)) {
            sb.append("N/A");
        }
        return sb.toString();
    }
}

