/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.msadpcm;

import com.sun.media.BasicPlugIn;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.msadpcm.MsAdpcm;
import com.sun.media.codec.audio.msadpcm.MsAdpcmState;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private static final boolean DEBUG = true;
    private MsAdpcmState[] state;

    public JavaDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("msadpcm")};
    }

    public String getName() {
        return "msadpcm decoder";
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (BasicPlugIn.matches(in, this.inputFormats) == null) {
            return new Format[0];
        }
        if (!(in instanceof AudioFormat)) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        AudioFormat af = (AudioFormat)in;
        int frameSize = af.getFrameSizeInBits();
        if (frameSize != 2048 && frameSize != 4096 && frameSize != 8192) {
            return new Format[0];
        }
        return new Format[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 0, 1)};
    }

    public void open() {
        this.state = new MsAdpcmState[2];
        this.state[0] = new MsAdpcmState();
        this.state[1] = new MsAdpcmState();
    }

    public void close() {
        this.state[0] = null;
        this.state[1] = null;
        this.state = null;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, inData.length * 4);
        AudioFormat iaf = (AudioFormat)inputBuffer.getFormat();
        int blockAlign = iaf.getFrameSizeInBits() >> 3;
        int channels = iaf.getChannels();
        int outLength = this.decode(inData, outData, inputBuffer.getLength(), blockAlign, channels);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }

    private int decode(byte[] inpData, byte[] outData, int inLength, int blockAlign, int channels) {
        int dataBytesInBlock = blockAlign - 7 * channels;
        int outBytes = 4 * channels + (blockAlign - 7 * channels) * 4;
        int readPtr = 0;
        int writePtr = 0;
        int numberOfBlocks = inLength / blockAlign;
        int n2 = 1;
        while (n2 <= numberOfBlocks) {
            MsAdpcm.decodeBlock(inpData, readPtr, outData, writePtr, dataBytesInBlock, this.state, channels);
            ++n2;
            writePtr += outBytes;
            readPtr += blockAlign;
        }
        return writePtr;
    }
}

