/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.sun.media.JMFSecurityManager;
import com.sun.media.util.DynamicPlugIn;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class ACMCodec
implements Codec,
DynamicPlugIn {
    private Vector supportedInputFormats = null;
    private Vector supportedOutputFormats = null;
    private AudioFormat[] inputFormats = null;
    private AudioFormat[] outputFormats = null;
    private AudioFormat inputFormat = null;
    private AudioFormat outputFormat = null;
    private long nativeHandle;

    public Object[] getControls() {
        return new Control[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    public String getName() {
        return "ACM Wrapper Codec";
    }

    public void open() throws ResourceUnavailableException {
        this.nativeHandle = this.openACMStream(this.inputFormat, this.outputFormat);
        if (this.nativeHandle == 0L) {
            throw new ResourceUnavailableException("ACM stream coun't been opened");
        }
    }

    private native long openACMStream(AudioFormat var1, AudioFormat var2);

    public void close() {
        this.closeACMStream(this.nativeHandle);
    }

    private native void closeACMStream(long var1);

    public void reset() {
        this.resetACMStream(this.nativeHandle);
    }

    private native void resetACMStream(long var1);

    public Format[] getSupportedInputFormats() {
        if (this.inputFormats != null) {
            return this.inputFormats;
        }
        this.supportedInputFormats = new Vector();
        this.fillSupportedInputFormats();
        int size = this.supportedInputFormats.size();
        this.inputFormats = new AudioFormat[size];
        int index = 0;
        while (index < size) {
            this.inputFormats[index] = (AudioFormat)this.supportedInputFormats.elementAt(index);
            ++index;
        }
        return this.inputFormats;
    }

    private native void fillSupportedInputFormats();

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            this.outputFormats = new AudioFormat[1];
            this.outputFormats[0] = new AudioFormat(null);
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            this.outputFormats = new AudioFormat[0];
            return this.outputFormats;
        }
        this.supportedOutputFormats = new Vector();
        this.fillSupportedOutputFormats((AudioFormat)input);
        int size = this.supportedOutputFormats.size();
        this.outputFormats = new AudioFormat[size];
        int index = 0;
        while (index < size) {
            this.outputFormats[index] = (AudioFormat)this.supportedOutputFormats.elementAt(index);
            ++index;
        }
        return this.outputFormats;
    }

    private native void fillSupportedOutputFormats(AudioFormat var1);

    public Format setInputFormat(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.inputFormat = (AudioFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.outputFormat = (AudioFormat)format;
        return format;
    }

    public int process(Buffer input, Buffer output) {
        if (input.isEOM()) {
            output.setLength(0);
            output.setEOM(true);
            return 0;
        }
        int oldInputOffset = input.getOffset();
        int destLength = this.getDestinationBufferSize(this.nativeHandle, input.getLength());
        if (output.getData() == null || destLength > ((byte[])output.getData()).length) {
            byte[] destination = new byte[destLength];
            output.setData(destination);
        }
        output.setLength(destLength);
        output.setOffset(0);
        output.setFormat(this.outputFormat);
        if (!this.ACMProcess(this.nativeHandle, (byte[])input.getData(), input.getOffset(), input.getLength(), input, (byte[])output.getData(), output.getLength(), output)) {
            return 1;
        }
        if (oldInputOffset != input.getOffset()) {
            return 2;
        }
        return 0;
    }

    private native int getDestinationBufferSize(long var1, int var3);

    private native boolean ACMProcess(long var1, byte[] var3, int var4, int var5, Buffer var6, byte[] var7, int var8, Buffer var9);

    public Format[] getBaseInputFormats() {
        Format[] formats = new Format[]{new AudioFormat(null)};
        return formats;
    }

    public Format[] getBaseOutputFormats() {
        return this.getBaseInputFormats();
    }

    static {
        JMFSecurityManager.loadLibrary("jmacm");
    }
}

