/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import jdk.internal.event.EventHelper;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.jfr.events.X509CertificateEvent;
import oracle.jrockit.jfr.VMJFR;
import sun.security.util.KeyUtil;

@InstrumentationTarget(value="sun.security.jca.JCAUtil")
final class JCAUtilInstrumentor {
    private JCAUtilInstrumentor() {
    }

    @InstrumentationMethod
    public static void tryCommitCertEvent(Certificate certificate) {
        if (!VMJFR.x509CertificateToken.isEnabled()) {
            JCAUtilInstrumentor.tryCommitCertEvent(certificate);
            return;
        }
        X509CertificateEvent x509CertificateEvent = new X509CertificateEvent(VMJFR.x509CertificateToken);
        if ((x509CertificateEvent.shouldWrite() || EventHelper.isLoggingSecurity()) && certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            PublicKey publicKey = x509Certificate.getPublicKey();
            String string = x509Certificate.getSigAlgName();
            String string2 = x509Certificate.getSerialNumber().toString(16);
            String string3 = x509Certificate.getSubjectX500Principal().toString();
            String string4 = x509Certificate.getIssuerX500Principal().toString();
            String string5 = publicKey.getAlgorithm();
            int n = KeyUtil.getKeySize(publicKey);
            int n2 = x509Certificate.hashCode();
            long l = x509Certificate.getNotBefore().getTime();
            long l2 = x509Certificate.getNotAfter().getTime();
            if (x509CertificateEvent.shouldWrite()) {
                x509CertificateEvent.algorithm = string;
                x509CertificateEvent.serialNumber = string2;
                x509CertificateEvent.subject = string3;
                x509CertificateEvent.issuer = string4;
                x509CertificateEvent.keyType = string5;
                x509CertificateEvent.keyLength = n;
                x509CertificateEvent.certificateId = n2;
                x509CertificateEvent.validFrom = l;
                x509CertificateEvent.validUntil = l2;
                x509CertificateEvent.commit();
            }
            if (EventHelper.isLoggingSecurity()) {
                EventHelper.logX509CertificateEvent(string, string2, string3, string4, string5, n, n2, l, l2);
            }
        }
    }
}

