/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.model;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCloneUtil;
import ext.lib.orm.entity.OrmAbstractEntity;
import ext.lib.orm.entity.OrmPersistenceEntity;
import ext.lib.orm.entity.OrmPersistenceField;
import ext.module.xmmd.model.XmmdField;
import ext.module.xmmd.model.XmmdIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@OrmPersistenceEntity(primaryKeyField="schemaId, tableName", columnNameConvert=true)
public class XmmdModel
extends OrmAbstractEntity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3421939068063823152L;
    public int schemaId;
    public String tableName;
    public String logicalName;
    public String wordCode;
    public String note;
    @OrmPersistenceField(enable=false)
    public List<XmmdField> fieldList = new ArrayList<XmmdField>();
    @OrmPersistenceField(enable=false)
    public Map<String, XmmdField> fieldNameMap = new TreeMap<String, XmmdField>();
    @OrmPersistenceField(enable=false)
    public Map<String, XmmdIndex> indexNameMap = new TreeMap<String, XmmdIndex>();
    @OrmPersistenceField(enable=false)
    public String primaryIndexName;

    public XmmdModel() {
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.schemaId = -1;
        this.tableName = null;
        this.logicalName = null;
        this.wordCode = null;
        this.note = null;
        this.fieldList.clear();
        this.fieldNameMap.clear();
        this.indexNameMap.clear();
        this.primaryIndexName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(XmmdField xmmdField) {
        List<XmmdField> list = this.fieldList;
        synchronized (list) {
            this.fieldList.add(xmmdField);
            this.fieldNameMap.put(xmmdField.columnName, xmmdField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmmdField removeField(int index) {
        List<XmmdField> list = this.fieldList;
        synchronized (list) {
            XmmdField mmdField = this.fieldList.remove(index);
            this.fieldNameMap.remove(mmdField.columnName);
            return mmdField;
        }
    }

    public XmmdField getField(int index) {
        return this.fieldList.get(index);
    }

    public int getFieldCount() {
        return this.fieldList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldIndexByName(String fieldName) {
        List<XmmdField> list = this.fieldList;
        synchronized (list) {
            int resValue = -1;
            if (BcStringUtil.isEmpty(fieldName)) {
                return resValue;
            }
            int i = 0;
            while (i < this.getFieldCount()) {
                XmmdField field2 = this.getField(i);
                if (BcStringUtil.equals(field2.columnName, fieldName)) {
                    resValue = i;
                    break;
                }
                ++i;
            }
            return resValue;
        }
    }

    public XmmdField getFieldByName(String fieldName) {
        return this.fieldNameMap.get(fieldName);
    }

    public XmmdIndex getPrimaryKey() {
        XmmdIndex xmmdIndex = null;
        if (!BcStringUtil.isEmpty(this.primaryIndexName)) {
            xmmdIndex = this.getIndex(this.primaryIndexName);
        }
        return xmmdIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(XmmdIndex xmmdIndex) {
        List<XmmdField> list = this.fieldList;
        synchronized (list) {
            this.indexNameMap.put(xmmdIndex.indexName, xmmdIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmmdIndex getIndex(String indexName) {
        List<XmmdField> list = this.fieldList;
        synchronized (list) {
            return this.indexNameMap.get(indexName);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return BcCloneUtil.createClone(this);
    }
}

