/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.AntFilterReader;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Parameterizable;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public final class ChainReaderHelper {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public Reader primaryReader;
    public int bufferSize = 8192;
    public Vector<FilterChain> filterChains = new Vector();
    private Project project = null;

    public void setPrimaryReader(Reader rdr) {
        this.primaryReader = rdr;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setFilterChains(Vector<FilterChain> fchain) {
        this.filterChains = fchain;
    }

    public Reader getAssembledReader() throws BuildException {
        if (this.primaryReader == null) {
            throw new BuildException("primaryReader must not be null.");
        }
        Reader instream = this.primaryReader;
        int filterReadersCount = this.filterChains.size();
        Vector<Object> finalFilters = new Vector<Object>();
        final ArrayList<AntClassLoader> classLoadersToCleanUp = new ArrayList<AntClassLoader>();
        int i = 0;
        while (i < filterReadersCount) {
            FilterChain filterchain = this.filterChains.elementAt(i);
            Vector<Object> filterReaders = filterchain.getFilterReaders();
            int readerCount = filterReaders.size();
            int j = 0;
            while (j < readerCount) {
                finalFilters.addElement(filterReaders.elementAt(j));
                ++j;
            }
            ++i;
        }
        int filtersCount = finalFilters.size();
        if (filtersCount > 0) {
            boolean success = false;
            try {
                int i2 = 0;
                while (i2 < filtersCount) {
                    Object o = finalFilters.elementAt(i2);
                    if (o instanceof AntFilterReader) {
                        instream = this.expandReader((AntFilterReader)finalFilters.elementAt(i2), instream, classLoadersToCleanUp);
                    } else if (o instanceof ChainableReader) {
                        this.setProjectOnObject(o);
                        instream = ((ChainableReader)o).chain(instream);
                        this.setProjectOnObject(instream);
                    }
                    ++i2;
                }
                success = true;
            }
            finally {
                if (!success && classLoadersToCleanUp.size() > 0) {
                    ChainReaderHelper.cleanUpClassLoaders(classLoadersToCleanUp);
                }
            }
        }
        Reader finalReader = instream;
        return classLoadersToCleanUp.size() == 0 ? finalReader : new FilterReader(finalReader){

            @Override
            public void close() throws IOException {
                FileUtils.close(this.in);
                ChainReaderHelper.cleanUpClassLoaders(classLoadersToCleanUp);
            }

            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }
        };
    }

    private void setProjectOnObject(Object obj) {
        if (this.project == null) {
            return;
        }
        if (obj instanceof BaseFilterReader) {
            ((BaseFilterReader)obj).setProject(this.project);
            return;
        }
        this.project.setProjectReference(obj);
    }

    private static void cleanUpClassLoaders(List<AntClassLoader> loaders) {
        Iterator<AntClassLoader> it = loaders.iterator();
        while (it.hasNext()) {
            it.next().cleanup();
        }
    }

    public String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, this.bufferSize);
    }

    private Reader expandReader(AntFilterReader filter, Reader ancestor, List<AntClassLoader> classLoadersToCleanUp) {
        String className = filter.getClassName();
        Path classpath = filter.getClasspath();
        Project pro = filter.getProject();
        if (className != null) {
            try {
                Class<?> clazz = null;
                if (classpath == null) {
                    clazz = Class.forName(className);
                } else {
                    AntClassLoader al = pro.createClassLoader(classpath);
                    classLoadersToCleanUp.add(al);
                    clazz = Class.forName(className, true, al);
                }
                if (clazz != null) {
                    if (!FilterReader.class.isAssignableFrom(clazz)) {
                        throw new BuildException(String.valueOf(className) + " does not extend" + " java.io.FilterReader");
                    }
                    Constructor<?>[] constructors = clazz.getConstructors();
                    int j = 0;
                    boolean consPresent = false;
                    while (j < constructors.length) {
                        Class<?>[] types = constructors[j].getParameterTypes();
                        if (types.length == 1 && types[0].isAssignableFrom(Reader.class)) {
                            consPresent = true;
                            break;
                        }
                        ++j;
                    }
                    if (!consPresent) {
                        throw new BuildException(String.valueOf(className) + " does not define" + " a public constructor" + " that takes in a Reader" + " as its single argument.");
                    }
                    Object[] rdr = new Reader[]{ancestor};
                    Reader instream = (Reader)constructors[j].newInstance(rdr);
                    this.setProjectOnObject(instream);
                    if (Parameterizable.class.isAssignableFrom(clazz)) {
                        Parameter[] params = filter.getParams();
                        ((Parameterizable)((Object)instream)).setParameters(params);
                    }
                    return instream;
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new BuildException(cnfe);
            }
            catch (InstantiationException ie) {
                throw new BuildException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new BuildException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new BuildException(ite);
            }
        }
        return ancestor;
    }
}

