/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import org.apache.bsf.util.StringUtils;

public class ObjInfo {
    private static String QUOTE_CHARS = "'\"";
    private static String EXEC_CHARS = "(=";
    public String objName;
    public Class objClass;

    public ObjInfo(Class objClass, String objName) {
        this.objClass = objClass;
        this.objName = objName;
    }

    public boolean isExecutable() {
        char[] chars = this.objName.toCharArray();
        char openingChar = ' ';
        boolean inString = false;
        boolean inEscapeSequence = false;
        int i = 0;
        while (i < chars.length) {
            if (inEscapeSequence) {
                inEscapeSequence = false;
            } else if (QUOTE_CHARS.indexOf(chars[i]) != -1) {
                if (!inString) {
                    openingChar = chars[i];
                    inString = true;
                } else if (chars[i] == openingChar) {
                    inString = false;
                }
            } else if (EXEC_CHARS.indexOf(chars[i]) != -1) {
                if (!inString) {
                    return true;
                }
            } else if (inString && chars[i] == '\\') {
                inEscapeSequence = true;
            }
            ++i;
        }
        return false;
    }

    public boolean isValueReturning() {
        return this.objClass != Void.TYPE && this.objClass != Void.class;
    }

    public String toString() {
        return String.valueOf(StringUtils.getClassName(this.objClass)) + " " + this.objName;
    }
}

