/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.core.BcStringUtil;
import ext.base.io.BcStringWriter;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.util.FxColorUtil;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import javafx.scene.Node;
import javafx.scene.paint.Color;

public class HfxConsolePane
extends FxBorderPane {
    public FxTextArea textArea = new FxTextArea();
    public InnerWriter writer = new InnerWriter();

    public HfxConsolePane() throws Exception {
        this.textArea.setEditable(false);
        this.textArea.setWrapText(true);
        Color bgColor = FxColorUtil.convFromAwt(SwgLafManager.getInstance().consoleBgColor);
        Color fgColor = FxColorUtil.convFromAwt(SwgLafManager.getInstance().consoleFgColor);
        this.textArea.setContentStyle(FxCssUtil.css_backgroundColor(bgColor));
        this.textArea.setStyle(FxCssUtil.css_textFill(fgColor));
        this.setCenter((Node)this.textArea);
    }

    public void addLine(Object str) {
        if (!BcStringUtil.isEmpty(this.textArea.getText())) {
            this.textArea.appendText("\n");
        }
        if (str != null) {
            this.textArea.appendText(str.toString());
        }
    }

    class InnerWriter
    extends BcStringWriter {
        InnerWriter() {
        }

        @Override
        protected void output(final String str) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    ((InnerWriter)InnerWriter.this).HfxConsolePane.this.textArea.appendText(str);
                }
            });
        }
    }
}

