/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxComboBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxPasswordField;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlWords;
import ext.module.xdts.fx.XdtsProfileSelectPane;
import ext.module.xdts.model.XdtsProfile;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.FileChooser;

public class XdtsDatasourcePane
extends FxBorderPane {
    protected Mode mode;
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField nameTextField = new FxTextField();
    FxTextField driverTextField = new FxTextField();
    FxComboBox<String> driverComboBox = new FxComboBox();
    FxTextField urlTextField = new FxTextField();
    FxComboBox<String> urlComboBox = new FxComboBox();
    FxTextField userTextField = new FxTextField();
    FxPasswordField passwordField = new FxPasswordField();
    FxTextArea parametersTextArea = new FxTextArea();
    FxTextField groupTextField = new FxTextField();
    FxTextField noteTextField = new FxTextField();
    FxTextField driverFilePathField = new FxTextField();
    FxButton fileBrowsButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    FxButton profileBrowsButton = FxUtil.createBrowsButton(null);
    XdtsProfile profile;

    public XdtsDatasourcePane(Mode mode) throws Exception {
        this.mode = mode;
        switch (mode) {
            case edit: 
            case editDestination: {
                this.setComponant_edit();
                break;
            }
            case editSimple: {
                this.setComponant_editSimple();
                break;
            }
            case display: {
                this.setComponant_display();
                break;
            }
            case displaySimple: {
                this.setComponant_displaySimple();
            }
        }
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponant_edit() throws Exception {
        this.nameTextField.setPrefColumnCount(80);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().dataSourceName), new Node[]{this.nameTextField});
        if (this.mode == Mode.editDestination) {
            this.profileBrowsButton.setOnAction(this.actionEventHandler);
            nodeUnit.addRightNodes(new Node[]{this.profileBrowsButton});
            this.nameTextField.setEditable(false);
        }
        this.centerPane.addNodeUnit(nodeUnit);
        this.setupDriverComboBox(this.driverComboBox);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().driverClass), new Node[]{this.driverComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setupUrlComboBox(this.urlComboBox);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.urlComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.userTextField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.passwordField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().password), new Node[]{this.passwordField});
        nodeUnit.arrangement = 1;
        this.centerPane.addNodeUnit(nodeUnit);
        this.parametersTextArea.setPrefColumnCount(100);
        this.parametersTextArea.setPrefRowCount(4);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().parameter), new Node[]{this.parametersTextArea});
        this.centerPane.addNodeUnit(nodeUnit);
        this.driverFilePathField.setPrefColumnCount(100);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().driverFile.toPlain()), new Node[]{this.driverFilePathField});
        this.fileBrowsButton.setOnAction(this.actionEventHandler);
        nodeUnit.addRightNodes(new Node[]{this.fileBrowsButton});
        this.centerPane.addNodeUnit(nodeUnit);
        if (this.mode == Mode.edit) {
            this.groupTextField.setPrefColumnCount(40);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().group), new Node[]{this.groupTextField});
            this.centerPane.addNodeUnit(nodeUnit);
            this.noteTextField.setPrefColumnCount(100);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
            this.centerPane.addNodeUnit(nodeUnit);
        } else if (this.mode == Mode.editDestination) {
            this.setPrefSize(920.0, 240.0);
        }
    }

    protected void setComponant_editSimple() throws Exception {
        this.setupDriverComboBox(this.driverComboBox);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().driverClass), new Node[]{this.driverComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setupUrlComboBox(this.urlComboBox);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.urlComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.userTextField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.passwordField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().password), new Node[]{this.passwordField});
        nodeUnit.arrangement = 1;
        this.centerPane.addNodeUnit(nodeUnit);
        this.parametersTextArea.setPrefColumnCount(100);
        this.parametersTextArea.setPrefRowCount(2);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().parameter), new Node[]{this.parametersTextArea});
        this.centerPane.addNodeUnit(nodeUnit);
        this.driverFilePathField.setPrefColumnCount(100);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().driverFile.toPlain()), new Node[]{this.driverFilePathField});
        this.fileBrowsButton.setOnAction(this.actionEventHandler);
        nodeUnit.addRightNodes(new Node[]{this.fileBrowsButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setPrefSize(940.0, 172.0);
    }

    protected void setComponant_display() throws Exception {
        this.nameTextField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().dataSourceName), new Node[]{this.nameTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.urlTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.urlTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.userTextField.setPrefColumnCount(20);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.groupTextField.setPrefColumnCount(20);
        nodeUnit.addRightNodes(new Node[]{new FxLabel(BcWords.getInstance().group), this.groupTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.noteTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setPrefSize(680.0, 110.0);
    }

    protected void setComponant_displaySimple() throws Exception {
        this.nameTextField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().dataSourceName), new Node[]{this.nameTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.urlTextField.setPrefColumnCount(60);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.urlTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.userTextField.setPrefColumnCount(20);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setPrefSize(560.0, 80.0);
    }

    public XdtsProfile getProfile() throws Exception {
        return this.profile;
    }

    public void setData(XdtsProfile profile) throws Exception {
        this.profile = profile;
        if (profile == null) {
            this.nameTextField.setText(null);
            this.driverTextField.setText(null);
            this.driverComboBox.setValue(null);
            this.urlTextField.setText(null);
            this.urlComboBox.setValue(null);
            this.userTextField.setText(null);
            this.passwordField.setText(null);
            this.parametersTextArea.setText(null);
            this.groupTextField.setText(null);
            this.noteTextField.setText(null);
            this.driverFilePathField.setText(null);
        } else {
            this.nameTextField.setText(profile.name);
            this.driverTextField.setText(profile.driver);
            this.driverComboBox.setValue(profile.driver);
            this.urlTextField.setText(profile.url);
            this.urlComboBox.setValue(profile.url);
            this.userTextField.setText(profile.user);
            this.passwordField.setText(profile.password);
            this.parametersTextArea.setText(profile.parameters);
            this.groupTextField.setText(profile.group);
            this.noteTextField.setText(profile.note);
            this.driverFilePathField.setText(profile.driverFilePath);
        }
    }

    public void storeData(XdtsProfile profile) throws Exception {
        profile.name = this.nameTextField.getText();
        profile.driver = (String)this.driverComboBox.getValue();
        profile.url = (String)this.urlComboBox.getValue();
        profile.user = this.userTextField.getText();
        profile.password = this.passwordField.getText();
        profile.parameters = this.parametersTextArea.getText();
        profile.group = this.groupTextField.getText();
        profile.note = this.noteTextField.getText();
        profile.driverFilePath = this.driverFilePathField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        XdtsProfileSelectPane profileSelectPane;
        XdtsProfile profile2;
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileBrowsButton) {
            FxUtil.initFileChooser(this.fileChooser, this.driverFilePathField.getText());
            File file = this.fileChooser.showOpenDialog(this.getScene().getWindow());
            if (file != null) {
                this.driverFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.profileBrowsButton && (profile2 = (profileSelectPane = new XdtsProfileSelectPane()).show(this.getScene().getWindow())) != null) {
            this.setData(profile2);
        }
    }

    public void setupDriverComboBox(FxComboBox<String> comboBox) throws Exception {
        comboBox.columnCount.set(100);
        comboBox.setEditable(true);
        comboBox.getItems().add((Object)"org.h2.Driver");
        comboBox.getItems().add((Object)"org.postgresql.Driver");
        comboBox.getItems().add((Object)"com.mysql.jdbc.Driver");
        comboBox.getItems().add((Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver");
        comboBox.getItems().add((Object)"oracle.jdbc.driver.OracleDriver");
        comboBox.getItems().add((Object)"sun.jdbc.odbc.JdbcOdbcDriver");
    }

    public void setupUrlComboBox(FxComboBox<String> comboBox) throws Exception {
        comboBox.columnCount.set(100);
        comboBox.setEditable(true);
        comboBox.getItems().add((Object)"jdbc:h2:file:C:\\hoge");
        comboBox.getItems().add((Object)"jdbc:postgresql://localhost/hoge");
        comboBox.getItems().add((Object)"jdbc:mysql://localhost:3306/hoge");
        comboBox.getItems().add((Object)"jdbc:sqlserver://localhost;databaseName=hoge");
        comboBox.getItems().add((Object)"jdbc:oracle:thin:@");
        comboBox.getItems().add((Object)"jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=");
    }

    public static enum Mode {
        edit(1),
        editDestination(2),
        editSimple(3),
        display(21),
        displaySimple(22);

        public final int id;

        private Mode(int id) {
            this.id = id;
        }
    }
}

