/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.UUID;

public final class BcUuidUtil {
    protected int unique;
    protected long time;
    protected static String address;
    private static int hostUnique;
    protected static Object mutex;
    protected static long lastTime;
    protected static long DELAY;

    static {
        hostUnique = new Object().hashCode();
        mutex = new Object();
        lastTime = System.currentTimeMillis();
        DELAY = 10L;
        try {
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(hostAddress.getBytes());
            byte[] hash = messageDigest.digest();
            address = new String(hash);
        }
        catch (Exception ex) {
            try {
                address = BcUuidUtil.generateNoNetworkId();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private BcUuidUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID createUUID() {
        Object object = mutex;
        synchronized (object) {
            boolean done = false;
            long time = 0L;
            while (!done) {
                time = System.currentTimeMillis();
                if (time < lastTime + DELAY) {
                    try {
                        Thread.sleep(DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                lastTime = time;
                done = true;
            }
            UUID uuid = new UUID(hostUnique, time);
            return uuid;
        }
    }

    private static String generateNoNetworkId() throws Exception {
        String nid = String.valueOf(Thread.activeCount()) + System.getProperty("os.version") + System.getProperty("user.name") + System.getProperty("java.version");
        System.out.println(nid);
        String hostAddress = InetAddress.getLocalHost().getHostAddress();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(nid.getBytes());
        byte[] hash = messageDigest.digest();
        return new String(hash);
    }
}

