/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import jdk.internal.org.xml.sax.Attributes;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.SAXParseException;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.SAXParser;
import jdk.internal.util.xml.XMLStreamException;
import jdk.internal.util.xml.impl.SAXParserImpl;
import jdk.internal.util.xml.impl.XMLStreamWriterImpl;

public class PropertiesDefaultHandler
extends DefaultHandler {
    private static final String ELEMENT_ROOT = "properties";
    private static final String ELEMENT_COMMENT = "comment";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTR_KEY = "key";
    private static final String PROPS_DTD_DECL = "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">";
    private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";
    private static final String EXTERNAL_XML_VERSION = "1.0";
    private Properties properties;
    static final String ALLOWED_ELEMENTS = "properties, comment, entry";
    static final String ALLOWED_COMMENT = "comment";
    StringBuffer buf = new StringBuffer();
    boolean sawComment = false;
    boolean validEntry = false;
    int rootElem = 0;
    String key;
    String rootElm;

    public void load(Properties properties, InputStream inputStream) throws IOException, InvalidPropertiesFormatException, UnsupportedEncodingException {
        this.properties = properties;
        try {
            SAXParserImpl sAXParserImpl = new SAXParserImpl();
            ((SAXParser)sAXParserImpl).parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            throw new InvalidPropertiesFormatException(sAXException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Properties properties, OutputStream outputStream, String string, String string2) throws IOException {
        try {
            XMLStreamWriterImpl xMLStreamWriterImpl = new XMLStreamWriterImpl(outputStream, string2);
            xMLStreamWriterImpl.writeStartDocument();
            xMLStreamWriterImpl.writeDTD(PROPS_DTD_DECL);
            xMLStreamWriterImpl.writeStartElement(ELEMENT_ROOT);
            if (string != null && !string.isEmpty()) {
                xMLStreamWriterImpl.writeStartElement("comment");
                xMLStreamWriterImpl.writeCharacters(string);
                xMLStreamWriterImpl.writeEndElement();
            }
            Properties properties2 = properties;
            synchronized (properties2) {
                for (Map.Entry entry : properties.entrySet()) {
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (!(k instanceof String) || !(v instanceof String)) continue;
                    xMLStreamWriterImpl.writeStartElement(ELEMENT_ENTRY);
                    xMLStreamWriterImpl.writeAttribute(ATTR_KEY, (String)k);
                    xMLStreamWriterImpl.writeCharacters((String)v);
                    xMLStreamWriterImpl.writeEndElement();
                }
            }
            xMLStreamWriterImpl.writeEndElement();
            xMLStreamWriterImpl.writeEndDocument();
            xMLStreamWriterImpl.close();
        }
        catch (XMLStreamException xMLStreamException) {
            if (xMLStreamException.getCause() instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)xMLStreamException.getCause();
            }
            throw new IOException(xMLStreamException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.rootElem < 2) {
            ++this.rootElem;
        }
        if (this.rootElm == null) {
            this.fatalError(new SAXParseException("An XML properties document must contain the DOCTYPE declaration as defined by java.util.Properties.", null));
        }
        if (this.rootElem == 1 && !this.rootElm.equals(string3)) {
            this.fatalError(new SAXParseException("Document root element \"" + string3 + "\", must match DOCTYPE root \"" + this.rootElm + "\"", null));
        }
        if (!ALLOWED_ELEMENTS.contains(string3)) {
            this.fatalError(new SAXParseException("Element type \"" + string3 + "\" must be declared.", null));
        }
        if (string3.equals(ELEMENT_ENTRY)) {
            this.validEntry = true;
            this.key = attributes.getValue(ATTR_KEY);
            if (this.key == null) {
                this.fatalError(new SAXParseException("Attribute \"key\" is required and must be specified for element type \"entry\"", null));
            }
        } else if (string3.equals("comment")) {
            if (this.sawComment) {
                this.fatalError(new SAXParseException("Only one comment element may be allowed. The content of element type \"properties\" must match \"(comment?,entry*)\"", null));
            }
            this.sawComment = true;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.validEntry) {
            this.buf.append(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!ALLOWED_ELEMENTS.contains(string3)) {
            this.fatalError(new SAXParseException("Element: " + string3 + " is invalid, must match  \"(comment?,entry*)\".", null));
        }
        if (this.validEntry) {
            this.properties.setProperty(this.key, this.buf.toString());
            this.buf.delete(0, this.buf.length());
            this.validEntry = false;
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.rootElm = string;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string2.equals(PROPS_DTD_URI)) {
            InputSource inputSource = new InputSource(new StringReader(PROPS_DTD));
            inputSource.setSystemId(PROPS_DTD_URI);
            return inputSource;
        }
        throw new SAXException("Invalid system identifier: " + string2);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }
}

