/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.barcode;

import ext.lib.swg.SwgImagePanel;
import ext.lib.swg.SwgUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import nlc.lib.barcode.DcfQrcode;

public class DcfQrcodeFactry {
    public Image createImage(String qrData) {
        int cellSize = 3;
        DcfQrcode qrcode = new DcfQrcode();
        qrcode.setQrcodeErrorCorrect('M');
        qrcode.setQrcodeEncodeMode('B');
        qrcode.setQrcodeVersion(7);
        byte[] d = qrData.getBytes();
        boolean[][] s = qrcode.calQrcode(d);
        BufferedImage image = new BufferedImage(s.length * cellSize, s.length * cellSize, 12);
        Graphics g = image.getGraphics();
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.setColor(Color.BLACK);
        int i = 0;
        while (i < s.length) {
            int j = 0;
            while (j < s.length) {
                if (s[j][i]) {
                    g.fillRect(j * cellSize, i * cellSize, cellSize, cellSize);
                }
                ++j;
            }
            ++i;
        }
        return image;
    }

    public static void main(String[] args) {
        try {
            DcfQrcodeFactry qrCodeSample = new DcfQrcodeFactry();
            String qrData = "\u3053\u308c\u306f\uff31\uff32\u30b3\u30fc\u30c9\u3067\u3059\u3088\uff01\u8aad\u3081\u305f\uff1f";
            Image image = qrCodeSample.createImage(qrData);
            SwgImagePanel imagePanel = new SwgImagePanel();
            imagePanel.setImage(image);
            imagePanel.setScaling(true);
            imagePanel.setKeepRatio(true);
            JFrame frame = new JFrame();
            frame.getContentPane().add((Component)imagePanel, "Center");
            SwgUtil.setCenter(frame, image.getWidth(null) + 20, image.getHeight(null) + 20);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

