/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.scheduler;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.core.BcTimeUtil_JP;
import ext.base.log.BcLoggableObject;
import ext.scf.scheduler.ScfSchedulerWords;
import ext.scf.scheduler.ScfTimerContext;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ScfScheduler
extends BcLoggableObject {
    protected Map<Integer, Timer> timerContextMap = new HashMap<Integer, Timer>();

    private ScfScheduler() {
    }

    public static ScfScheduler getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimerTask(ScfTimerContext timerContext, TimerTask timerTask) throws Exception {
        Map<Integer, Timer> map = this.timerContextMap;
        synchronized (map) {
            Timer timer = null;
            timer = BcStringUtil.isEmpty(timerContext.name) ? new Timer(true) : new Timer(timerContext.name, true);
            if (timerContext.triggerId == 11) {
                Calendar stratDateTime = null;
                stratDateTime = timerContext.startTime != null ? (Calendar)timerContext.startTime.clone() : BcTimeUtil.createCalendar();
                timer.scheduleAtFixedRate(timerTask, stratDateTime.getTime(), timerContext.intervalMillis);
                this.timerContextMap.put(timerContext.hashCode(), timer);
                this.getLogger().info("\u30bf\u30a4\u30de\u30bf\u30b9\u30af\u8ffd\u52a0\uff1a \u958b\u59cb\u65e5\u6642=" + BcTimeUtil.toString(stratDateTime) + "\t\u30c8\u30ea\u30ac\u30fc=" + ScfSchedulerWords.getInstance().toTriggerName(timerContext.triggerId) + " \u9593\u9694=" + BcNumberUtil.toString(timerContext.intervalMillis) + "\uff08\u30df\u30ea\u79d2\uff09");
            } else if (timerContext.triggerId == 21) {
                if (timerContext.intervalMillis < 1L) {
                    timerContext.intervalMillis = 1L;
                }
                BcTimeUtil.setToday(timerContext.startTime);
                DummyTimerTask dummyTimerTask = new DummyTimerTask(timerContext, timerTask);
                timer.scheduleAtFixedRate((TimerTask)dummyTimerTask, BcTimeUtil.createCalendar().getTime(), 10000L);
                this.timerContextMap.put(timerContext.hashCode(), timer);
                this.getLogger().info("\u30bf\u30a4\u30de\u30bf\u30b9\u30af\u8ffd\u52a0\uff1a \u958b\u59cb\u6642\u9593=" + BcTimeUtil.toString(timerContext.startTime, "HH:mm:ss") + "\t\u30c8\u30ea\u30ac\u30fc=" + ScfSchedulerWords.getInstance().toTriggerName(timerContext.triggerId) + " \u9593\u9694=" + timerContext.intervalMillis + "\uff08\u65e5\uff09");
            } else if (timerContext.triggerId == 22) {
                BcTimeUtil.setToday(timerContext.startTime);
                Calendar execCalendar = BcTimeUtil.toDayOfWeekMostNearly(timerContext.startTime, (int)timerContext.intervalMillis);
                DummyTimerTask dummyTimerTask = new DummyTimerTask(timerContext, timerTask);
                timer.scheduleAtFixedRate((TimerTask)dummyTimerTask, execCalendar.getTime(), 604800000L);
                this.timerContextMap.put(timerContext.hashCode(), timer);
                this.getLogger().info("\u30bf\u30a4\u30de\u30bf\u30b9\u30af\u8ffd\u52a0\uff1a\u30e2\u30fc\u30c9=" + ScfSchedulerWords.getInstance().toTriggerName(timerContext.triggerId) + " \u66dc\u65e5=" + BcTimeUtil_JP.toDayOfWeekName((int)timerContext.intervalMillis) + " \u6642\u9593=" + BcTimeUtil.toString(timerContext.startTime, "HH:mm:ss"));
            } else if (timerContext.triggerId == 23) {
                BcTimeUtil.setToday(timerContext.startTime);
                DummyTimerTask dummyTimerTask = new DummyTimerTask(timerContext, timerTask);
                timer.scheduleAtFixedRate((TimerTask)dummyTimerTask, timerContext.startTime.getTime(), 86400000L);
                this.timerContextMap.put(timerContext.hashCode(), timer);
                this.getLogger().info("\u30bf\u30a4\u30de\u30bf\u30b9\u30af\u8ffd\u52a0\uff1a \u30e2\u30fc\u30c9=" + ScfSchedulerWords.getInstance().toTriggerName(timerContext.triggerId) + " \u65e5=" + timerContext.intervalMillis + " \u6642\u9593=" + BcTimeUtil.toString(timerContext.startTime, "HH:mm:ss"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimer(ScfTimerContext timerContext) {
        Map<Integer, Timer> map = this.timerContextMap;
        synchronized (map) {
            Timer timer = this.timerContextMap.remove(timerContext.hashCode());
            if (timer != null) {
                this.getLogger().info("removeTimer:timer.hashCode()=" + timer.hashCode());
                timer.cancel();
            }
        }
    }

    public void removeAll() {
        ScfTimerContext[] timerContexts = this.timerContextMap.keySet().toArray(new ScfTimerContext[0]);
        int i = 0;
        while (i < timerContexts.length) {
            this.removeTimer(timerContexts[i]);
            ++i;
        }
    }

    /* synthetic */ ScfScheduler(ScfScheduler scfScheduler) {
        this();
    }

    protected class DummyTimerTask
    extends TimerTask {
        protected ScfTimerContext \uff54imerContext;
        protected TimerTask timerTask;

        public DummyTimerTask(ScfTimerContext \uff54imerContext, TimerTask timerTask) {
            this.\uff54imerContext = \uff54imerContext;
            this.timerTask = timerTask;
        }

        @Override
        public void run() {
            if (this.\uff54imerContext.triggerId == 21) {
                Calendar now = BcTimeUtil.createCalendar();
                Calendar tmpTime = (Calendar)this.\uff54imerContext.startTime.clone();
                BcTimeUtil.setToday(tmpTime);
                if (now.getTimeInMillis() <= tmpTime.getTimeInMillis()) {
                    this.\uff54imerContext.checkTime = now;
                }
                if (this.\uff54imerContext.checkTime != null && now.getTimeInMillis() >= tmpTime.getTimeInMillis()) {
                    Thread thread = new Thread(this.timerTask);
                    thread.start();
                    this.\uff54imerContext.checkTime = null;
                }
            } else if (this.\uff54imerContext.triggerId == 22) {
                Thread thread = new Thread(this.timerTask);
                thread.start();
            } else if (this.\uff54imerContext.triggerId == 23) {
                Calendar today = BcTimeUtil.createCalendar();
                if (this.\uff54imerContext.intervalMillis >= 31L) {
                    if (this.\uff54imerContext.intervalMillis == (long)today.get(5)) {
                        Thread thread = new Thread(this.timerTask);
                        thread.start();
                    }
                } else if (BcTimeUtil.isEndOfMonth(today)) {
                    Thread thread = new Thread(this.timerTask);
                    thread.start();
                }
            }
        }
    }

    private static final class SingletonHolder {
        private static final ScfScheduler instance = new ScfScheduler(null);

        private SingletonHolder() {
        }
    }
}

