/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.client;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbConstants;
import ext.appfw.common.AfbLogUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.reflect.BcReflectUtil;
import ext.base.runtime.BcRuntimeUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcEncoder;
import ext.base.util.BcWords;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.swg.SwgUtil;
import ext.module.advm.client.AdvmAdvertisementManager;
import ext.module.advm.client.AdvmAdvertisementTask;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xsys.fx.XdtsLicensePane;
import ext.module.xsys.fx.XsysDesktop;
import ext.module.xupd.client.XupdChacker;
import ext.scf.client.ScfAbstractClientModule;
import ext.scf5.swg.IswgTablePanel;
import java.io.File;
import java.nio.charset.Charset;
import javafx.application.Platform;

public class XsysClientModule
extends ScfAbstractClientModule {
    public BcMonitor monitor = new BcMonitor();
    boolean licenseAgreement;

    @Override
    public void init() throws Exception {
        String javaVersion = BcRuntimeUtil.getJavaVersion();
        boolean doExit = false;
        final BcMonitor monitor = new BcMonitor();
        if (!BcRuntimeUtil.isJava_1_8()) {
            doExit = true;
            monitor.lock();
            final String msg = String.format("\u672c\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f Java %s \u3067\u306f\u7a3c\u52d5\u3057\u307e\u305b\u3093\u3002", javaVersion);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FxOptionPane.showMessageDialog(msg, BcWords.getInstance().error, 0);
                        monitor.unLock();
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        }
        while (monitor.isLock()) {
            Thread.sleep(1000L);
        }
        if (doExit) {
            System.exit(AfbConstants.ExitCode.NG.code);
        }
    }

    @Override
    public void start() throws Exception {
        boolean isAgreement = this.licenseAgreement();
        if (!isAgreement) {
            AfbApplication.getInstance().exit(AfbConstants.ExitCode.OK.code);
            return;
        }
        IswgTablePanel.printButtonEnabled = false;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BcReflectUtil.invoke(XsysDesktop.class.getName(), "show2");
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected boolean licenseAgreement() throws Exception {
        String vPath = "${APP}data/license_agreement.log";
        String rPath = AfbApplication.getInstance().toReal(vPath);
        File agreementLogFile = new File(rPath);
        BcLogUtil.debug("agreementLogFile=" + agreementLogFile.getPath());
        if (agreementLogFile.exists()) {
            return true;
        }
        this.monitor.lock();
        vPath = "${APP}\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u4f7f\u7528\u8a31\u8afe\u5951\u7d04\u66f8.txt";
        rPath = AfbApplication.getInstance().toReal(vPath);
        File licenseFile = new File(rPath);
        String charsetName = BcEncoder.detectEncoding(licenseFile);
        Charset charset = Charset.forName(charsetName);
        final StringBuilder licenseStrBuf = BcFileUtil.readAsStringBuilder(new File(rPath), charset);
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> System.out.println("Inside Platform.runLater()"));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    XdtsLicensePane licensePane = new XdtsLicensePane();
                    licensePane.textArea.setText(licenseStrBuf.toString());
                    XsysClientModule.this.licenseAgreement = licensePane.show(null);
                    XsysClientModule.this.monitor.unLock();
                }
                catch (Exception ex) {
                    XsysClientModule.this.handleException(ex);
                }
            }
        });
        this.monitor.sync();
        if (this.licenseAgreement) {
            StringBuilder agreementLog = new StringBuilder();
            agreementLog.append(BcTimeUtil.toString(BcTimeUtil.createCalendar(), "yyyy/MM/dd HH:mm:ss.SSS"));
            agreementLog.append(AfbLogUtil.lineSeparator);
            agreementLog.append(AfbLogUtil.jvmInfoLog());
            BcFileUtil.makeParent(agreementLogFile);
            BcFileUtil.save(agreementLogFile, agreementLog.toString(), charset);
            return true;
        }
        return false;
    }

    protected int chackUpdate() throws Exception {
        XupdChacker xupdChacker = new XupdChacker();
        int exitCode = xupdChacker.check(this.monitor);
        this.monitor.sync();
        return exitCode;
    }

    protected void advertisement() throws Exception {
        AdvmAdvertisementManager advertisementManager = new AdvmAdvertisementManager();
        advertisementManager.setAdvertisementTask(new AdvmAdvertisementTask());
        try {
            advertisementManager.checkBootConfig(this.monitor);
            this.monitor.sync();
            XdtsConstants.LIMIT_tableCount = -1;
            XdtsConstants.LIMIT_recordCount = -1;
        }
        catch (Exception ex) {
            this.monitor.unLock();
            BcLogUtil.error(ex);
        }
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

