/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.base.core.BcTimeUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCompareUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.EtcSqlUtil;
import ext.lib.task.TskAbstractCallable;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.dao.XfilCrawlDAO;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.MovieInfo;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilAnalysisResult;
import ext.module.xfil.model.XfilConditionWowk;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.server.XfilServerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;

public class XfilFileCrawlTask
extends TskAbstractCallable {
    public XfilAnalysisCondition analysisCondition;
    public XfilConditionWowk crawlCondition;
    public XfilAnalysisResult analysisResult;
    int maxDepth = Integer.MAX_VALUE;
    public DtsSession dtsSessionWk;
    long fileCnt;
    public String note;
    public XfilCrawl crawl;
    public XfilUriEntityDAO uriEntitydao;
    public boolean isTest;
    FileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
            XfilFileCrawlTask.this.getLogger().info("Directory:=" + path);
            if (path.toFile().getName().equalsIgnoreCase("$RECYCLE.BIN")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return XfilFileCrawlTask.this.visitFile(path, attrs);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException ex) throws IOException {
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            return XfilFileCrawlTask.this.visitFile(path, attrs);
        }
    };

    public XfilCrawl taskProcess() throws Exception {
        try {
            this.missingFileDetection();
            XfilCrawl xfilCrawl = this.fileCrawl();
            return xfilCrawl;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            EtcSqlUtil.closeSession(this.dtsSessionWk, this.getLogger());
        }
    }

    public void missingFileDetection() throws Exception {
        if (this.isTest) {
            return;
        }
        this.getLogger().info("\u524a\u9664\u3001\u79fb\u52d5\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u51fa\u4e2d...");
        long entityId = -1L;
        List uriEntityList = this.uriEntitydao.getList(this.dtsSessionWk, XfilUriEntityDAO.Mode.id, entityId, this.crawl.id, null, null, null, -1, false);
        this.getLogger().info("\u691c\u67fb\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u6570=" + uriEntityList.size());
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
            if (uriEntity.missingDatetime == null) {
                File file = XfilUtil.toFile(uriEntity);
                this.getLogger().info(file.getPath());
                if (!file.exists()) {
                    this.getLogger().info("Not Found.");
                    uriEntity.missingDatetime = BcTimeUtil.createCalendar();
                    uriEntity.crawlSeq = this.crawl.seq;
                    this.uriEntitydao.putEntity(this.dtsSessionWk, uriEntity);
                    this.dtsSessionWk.commit();
                }
            }
            ++i;
        }
        XfilServerUtil.getInstance().createSummary(this.dtsSessionWk, this.crawl);
        this.dtsSessionWk.commit();
    }

    public XfilCrawl fileCrawl() throws Exception {
        EnumSet<FileVisitOption> fileVisitOptionSet = EnumSet.allOf(FileVisitOption.class);
        for (File dir : this.crawlCondition.dirList) {
            this.getLogger().info("dir=" + dir.getPath());
            Path path = dir.toPath();
            Files.walkFileTree(path, fileVisitOptionSet, this.maxDepth, this.fileVisitor);
        }
        XfilServerUtil.getInstance().createSummary(this.dtsSessionWk, this.crawl);
        this.crawl.endDateTime = BcTimeUtil.createCalendar();
        if (!this.isTest) {
            XfilCrawlDAO.getInstance().putEntity(this.dtsSessionWk, this.crawl);
            this.dtsSessionWk.commit();
        }
        return this.crawl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        ++this.fileCnt;
        if (this.fileCnt % 100L == 0L) {
            this.getLogger().info("fileCnt=" + this.fileCnt);
        }
        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
        try {
            if (Files.isHidden(path)) {
                return FileVisitResult.CONTINUE;
            }
            Files.isSymbolicLink(path);
            XfilUriEntity uriEntity1 = XfilUtil.toUriEntity(path);
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.getLogger().info("Directory:" + path.toFile().getName());
                if (!path.toFile().getName().equalsIgnoreCase("VIDEO_TS")) return FileVisitResult.CONTINUE;
                uriEntity1 = XfilUtil.toUriEntity(path.getParent());
                uriEntity1.childCount = path.toFile().listFiles().length;
                fileVisitResult = FileVisitResult.SKIP_SUBTREE;
            } else {
                uriEntity1.childCount = -1;
                if (!XfilUtil.isAllowedFileExtention(this.crawlCondition.fileExtentionList, uriEntity1.extention)) {
                    return FileVisitResult.CONTINUE;
                }
            }
            uriEntity1.text01 = this.note;
            List uriEntityList = this.uriEntitydao.getListByPath(this.dtsSessionWk, this.crawl.id, uriEntity1.directory, uriEntity1.name, false);
            if (uriEntityList.size() > 1) {
                this.getLogger().info(String.valueOf(uriEntity1.name) + " \u304c\u5b58\u5728\u3057\u307e\u3059\u3002" + uriEntityList.size() + "\u4ef6");
                return fileVisitResult;
            }
            String action = "ADD";
            if (uriEntityList.size() == 1) {
                XfilUriEntity uriEntity2 = (XfilUriEntity)BcCollectionUtil.getFirst(uriEntityList);
                List<String> diffList = XfilUtil.diff(uriEntity2, uriEntity1);
                if (BcTimeUtil.compare(uriEntity1.missingDatetime, uriEntity2.missingDatetime) != BcCompareUtil.Comparison.equals.value) {
                    diffList.add("missingDatetime");
                }
                if (diffList.size() <= 0) {
                    return FileVisitResult.CONTINUE;
                }
                this.getLogger().info("DIFF:" + diffList);
                uriEntity1.id = uriEntity2.id;
                action = "UPDATE";
            }
            this.getLogger().info(String.valueOf(action) + ":" + uriEntity1.name);
            uriEntity1.crawlId = this.crawl.id;
            uriEntity1.crawlSeq = this.crawl.seq;
            uriEntity1.addDatetime = BcTimeUtil.createCalendar();
            if (!this.isTest) {
                MovieInfo movieInfo = XfilUtil.setMovieInfo(uriEntity1, path.toFile());
            }
            uriEntity1.thumbnailDatetime = null;
            uriEntity1.error2 = null;
            this.uriEntitydao.putEntity(this.dtsSessionWk, uriEntity1);
            this.dtsSessionWk.commit();
            return fileVisitResult;
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        return fileVisitResult;
    }
}

