/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.util.BcWords;
import ext.lib.fx.control.FxCheckBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxNumberField;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.libx.etc.util.EtcAbstractConditionSet;
import ext.module.xfil.common.FfmpegUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.HorizontalPositionComboBox;
import ext.module.xfil.fx.ResolutionComboBox;
import ext.module.xfil.fx.VerticalPositionComboBox;
import ext.module.xfil.model.XfilVCaptureCondition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class XfilCaptureConditionSet
extends EtcAbstractConditionSet {
    ResolutionComboBox resolutionComboBox = new ResolutionComboBox();
    public FxNodeUnit resolutionUnit;
    FxNumberField capturingWidthField = new FxNumberField();
    FxNumberField capturingHeightField;
    FxNumberField intervalField;
    public FxNodeUnit intervalUnit;
    FxNumberField topMarginField;
    public FxNodeUnit topMarginUnit;
    FxNumberField botomMarginField;
    public FxNodeUnit botomMarginUnit;
    FxNumberField capturingCountMaxField;
    public FxNodeUnit capturingCountMaxUnit;
    FxCheckBox elapsedTimeCheckBox;
    HorizontalPositionComboBox elapsedTimeHorizontalPositionComboBox;
    VerticalPositionComboBox elapsedTimeVerticalPositionComboBox;
    public FxNodeUnit elapsedTimeUnit;

    public XfilCaptureConditionSet() throws Exception {
        this.capturingWidthField.setPrefColumnCount(4);
        FxNodeUnit capturingWidthUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(BcWords.getInstance().width) + "(px)"), new Node[]{this.capturingWidthField});
        this.capturingHeightField = new FxNumberField();
        this.capturingHeightField.setPrefColumnCount(4);
        FxNodeUnit capturingHeightUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(BcWords.getInstance().height) + "(px)"), new Node[]{this.capturingHeightField});
        FxFlowPane resolutionPane = new FxFlowPane(21);
        resolutionPane.topMargin = 0.0;
        resolutionPane.addNodeUnit(capturingWidthUnit);
        resolutionPane.addNodeUnit(capturingHeightUnit);
        resolutionPane.setPrefWidth(600.0);
        this.resolutionUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().Resolution.toPlain()), new Node[]{this.resolutionComboBox, resolutionPane});
        this.resolutionComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue ov, Object oldValue, Object newValue) {
                boolean editable = true;
                if (newValue instanceof FfmpegUtil.Resolution) {
                    FfmpegUtil.Resolution resolution = (FfmpegUtil.Resolution)((Object)newValue);
                    XfilCaptureConditionSet.this.capturingWidthField.setValue(resolution.width);
                    XfilCaptureConditionSet.this.capturingHeightField.setValue(resolution.height);
                    editable = false;
                }
                XfilCaptureConditionSet.this.capturingWidthField.setEditable(editable);
                XfilCaptureConditionSet.this.capturingHeightField.setEditable(editable);
            }
        });
        this.resolutionComboBox.setData();
        this.intervalField = new FxNumberField();
        this.intervalField.setPrefColumnCount(4);
        this.intervalUnit = new FxNodeUnit((Node)new FxLabel("\u30ad\u30e3\u30d7\u30c1\u30e3\u9593\u9694\uff08\u79d2\uff09"), new Node[]{this.intervalField});
        this.topMarginField = new FxNumberField();
        this.topMarginField.setPrefColumnCount(4);
        this.topMarginUnit = new FxNodeUnit((Node)new FxLabel("\u5148\u982d\u30de\u30fc\u30b8\u30f3\uff08\u79d2\uff09"), new Node[]{this.topMarginField});
        this.botomMarginField = new FxNumberField();
        this.botomMarginField.setPrefColumnCount(4);
        this.botomMarginUnit = new FxNodeUnit((Node)new FxLabel("\u672b\u5c3e\u30de\u30fc\u30b8\u30f3\uff08\u79d2\uff09"), new Node[]{this.botomMarginField});
        this.capturingCountMaxField = new FxNumberField();
        this.capturingCountMaxField.setPrefColumnCount(4);
        this.capturingCountMaxUnit = new FxNodeUnit((Node)new FxLabel("\u6700\u5927\u30ad\u30e3\u30d7\u30c1\u30e3\u6570"), new Node[]{this.capturingCountMaxField});
        this.elapsedTimeCheckBox = new FxCheckBox();
        this.elapsedTimeHorizontalPositionComboBox = new HorizontalPositionComboBox();
        this.elapsedTimeVerticalPositionComboBox = new VerticalPositionComboBox();
        FxNodeUnit unit1 = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().horizontalPosition), new Node[]{this.elapsedTimeHorizontalPositionComboBox});
        FxNodeUnit unit2 = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().verticalPosition), new Node[]{this.elapsedTimeVerticalPositionComboBox});
        FxFlowPane positionPane = new FxFlowPane(21);
        positionPane.topMargin = 0.0;
        positionPane.addNodeUnit(unit1);
        positionPane.addNodeUnit(unit2);
        positionPane.setPrefWidth(600.0);
        this.elapsedTimeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().elapsedTime), new Node[]{this.elapsedTimeCheckBox, positionPane});
        this.capturingWidthField.setValue(FfmpegUtil.Resolution._144p.width);
        this.capturingHeightField.setValue(FfmpegUtil.Resolution._144p.height);
        this.intervalField.setValue(600);
        this.topMarginField.setValue(10);
        this.botomMarginField.setValue(10);
        this.capturingCountMaxField.setValue(8);
        this.elapsedTimeHorizontalPositionComboBox.getSelectionModel().select((Object)0);
        this.elapsedTimeVerticalPositionComboBox.getSelectionModel().select((Object)3);
    }

    @Override
    public void clear() throws Exception {
    }

    public void setConditionSet(XfilCaptureConditionSet conditionSet) throws Exception {
        this.resolutionComboBox.getSelectionModel().select(conditionSet.resolutionComboBox.getSelectionModel().getSelectedItem());
        this.capturingWidthField.setValue(conditionSet.capturingWidthField.getBigDecimal());
        this.capturingWidthField.setValue(conditionSet.capturingWidthField.getBigDecimal());
        this.intervalField.setValue(conditionSet.intervalField.getBigDecimal());
        this.topMarginField.setValue(conditionSet.topMarginField.getBigDecimal());
        this.botomMarginField.setValue(conditionSet.botomMarginField.getBigDecimal());
        this.capturingCountMaxField.setValue(conditionSet.capturingCountMaxField.getBigDecimal());
        this.elapsedTimeCheckBox.setSelected(conditionSet.elapsedTimeCheckBox.isSelected());
        this.elapsedTimeHorizontalPositionComboBox.getSelectionModel().select((Object)((Integer)conditionSet.elapsedTimeHorizontalPositionComboBox.getSelectionModel().getSelectedItem()));
        this.elapsedTimeVerticalPositionComboBox.getSelectionModel().select((Object)((Integer)conditionSet.elapsedTimeVerticalPositionComboBox.getSelectionModel().getSelectedItem()));
    }

    public void getCondition(XfilVCaptureCondition condition) throws Exception {
        Object value = this.resolutionComboBox.getSelectionModel().getSelectedItem();
        if (value instanceof FfmpegUtil.Resolution) {
            FfmpegUtil.Resolution resolution = (FfmpegUtil.Resolution)((Object)value);
            condition.capturingWidth = resolution.width;
            condition.capturingHeight = resolution.height;
        } else {
            condition.capturingWidth = this.capturingWidthField.getBigDecimal().intValue();
            condition.capturingHeight = this.capturingHeightField.getBigDecimal().intValue();
        }
        condition.intervalSec = this.intervalField.getBigDecimal().intValue();
        condition.topMarginSec = this.topMarginField.getBigDecimal().intValue();
        condition.botomMarginSec = this.botomMarginField.getBigDecimal().intValue();
        condition.capturingCountMax = this.capturingCountMaxField.getBigDecimal().intValue();
        condition.elapsedTime = this.elapsedTimeCheckBox.isSelected();
        condition.elapsedTimeHorizontalPositionId = (Integer)this.elapsedTimeHorizontalPositionComboBox.getSelectionModel().getSelectedItem();
        condition.elapsedTimeVerticalPositionId = (Integer)this.elapsedTimeVerticalPositionComboBox.getSelectionModel().getSelectedItem();
    }

    public XfilVCaptureCondition getCondition() throws Exception {
        XfilVCaptureCondition condition = new XfilVCaptureCondition();
        this.getCondition(condition);
        return condition;
    }
}

