/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swt;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.lib.swt.SwtUtil;
import java.util.Calendar;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SwtWidgetFactory {
    public static Listener listenerForTabKey = new Listener(){

        public void handleEvent(Event ev) {
            switch (ev.keyCode) {
                case 9: 
                case 13: {
                    ev.doit = false;
                    try {
                        SwtUtil.nextFocus((Control)ev.widget);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    };

    private SwtWidgetFactory() throws Exception {
    }

    public static Label createLabelRight(Composite composite, String text) throws Exception {
        Label label = new Label(composite, 131072);
        if (!BcStringUtil.isEmpty(text)) {
            label.setText(text);
        }
        return label;
    }

    public static Text createText(Composite composite, int style) throws Exception {
        Text text = new Text(composite, style);
        text.addListener(25, listenerForTabKey);
        return text;
    }

    public static Text createText(Composite composite) throws Exception {
        return SwtWidgetFactory.createText(composite, 2050);
    }

    public static Text createDateText(Composite composite) throws Exception {
        return SwtWidgetFactory.createText(composite);
    }

    public static Text createDateText(Composite composite, Calendar calendar) throws Exception {
        Text text = SwtWidgetFactory.createDateText(composite);
        if (calendar != null) {
            text.setText(BcTimeUtil.toString(calendar, "yyyyMMdd"));
        }
        return text;
    }

    public static Text createDateText(Composite composite, int yyyyMMdd) throws Exception {
        Text text = SwtWidgetFactory.createDateText(composite);
        if (yyyyMMdd > 0) {
            text.setText(Integer.toString(yyyyMMdd));
        }
        return text;
    }

    public static Button createButton(Composite composite, int style) throws Exception {
        Button button = new Button(composite, style);
        button.addListener(25, listenerForTabKey);
        return button;
    }

    public static Button createButton(Composite composite, String title) throws Exception {
        Button button = SwtWidgetFactory.createButton(composite, 0x1000008);
        if (!BcStringUtil.isEmpty(title)) {
            button.setText(title);
        }
        button.pack();
        return button;
    }

    public static Combo createCombo(Composite composite, int style) throws Exception {
        Combo combo = new Combo(composite, style);
        return combo;
    }

    public static Combo createCombo(Composite composite) throws Exception {
        return SwtWidgetFactory.createCombo(composite, 8);
    }
}

