/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.lib.fx.control.FxTextField;
import java.util.Calendar;
import javafx.geometry.Pos;

public class FxDateField
extends FxTextField {
    private Calendar calendar;
    private String format;
    private int mode = 1;
    private boolean allZeroEnabled;

    public boolean isAllZeroEnabled() {
        return this.allZeroEnabled;
    }

    public void setAllZeroEnabled(boolean allZeroEnabled) {
        this.allZeroEnabled = allZeroEnabled;
    }

    public FxDateField() throws Exception {
        this.setAlignment(Pos.CENTER_LEFT);
        this.setFormat("yyyy/MM/dd");
    }

    @Override
    public void textEdited() {
        this.calendar = null;
        String text = this.getText();
        if (BcStringUtil.isEmpty(text)) {
            super.setText(null);
            return;
        }
        if (this.mode == 11) {
            if (text.matches("[0-9]{2,4}/[0-9]{1,2}")) {
                text = String.valueOf(text) + "/01";
            } else if (text.matches("[0-9]{5,6}")) {
                text = String.valueOf(text) + "01";
            }
        }
        try {
            this.calendar = BcStringUtil.equals(text, "9999/99/99") ? BcTimeUtil.toCalendar(99999999) : BcTimeUtil.toCalendar(text);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        this.setCalendar(this.calendar);
    }

    public Calendar getCalendar() throws Exception {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        if (calendar == null) {
            if (this.isAllZeroEnabled()) {
                this.setText("0000/00/00");
            } else {
                this.setText(null);
            }
        } else if (BcTimeUtil.isMaxDate(calendar)) {
            this.setText("9999/99/99");
        } else {
            this.setText(BcTimeUtil.toString(calendar, this.format));
        }
    }

    public int getYyyyMMdd() throws Exception {
        return BcTimeUtil.toYyyyMMdd(this.calendar);
    }

    public void setYyyyMMdd(int yyyyMMdd) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        this.setCalendar(calendar);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) throws Exception {
        this.format = format;
        this.setPrefColumnCount(format.length());
    }
}

